local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

local level = 84

br_core.register_level({
    level = 84,
    desc = "Level 84",
    weather = "heavy_rain",
    danger = 2,
    grace_dist = 5,
    biome = {},
    segsize = 16,
    -- shift_x = 10,
    biome_roughness = 22.728,
    -- level_height = 160,
    biome_pixelization = 3,
    base_height = 10,
    on_generate = function(self, pos, perlin)
        if pos.x % 20 == 0 then
            if pos.z % 20 == 0 then
                return "canal_intersection"
            else
                return "canal_north"
            end
        elseif pos.z % 20 == 0 then
            return "canal_east"
        end
    end,
    sun = {
        visible = true,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    clouds = {
        density = 0.6,
        thickness = 2.3,
        ambient = "#333",
        color = "#33333320",
        height = level * br_core.level_height - br_core.offset + 80 + 50,
        speed = {x=6.9, z=12}
    },
    sky = {
		base_color = "#ffffff",
		type = "regular",
		clouds = true,
		sky_color = {
			day_sky = "#839cb2" ,
			day_horizon = "#4c5b6a",
			dawn_sky = "#5d5d5f" ,
			dawn_horizon = "#843e36",
			night_sky = "#fff" ,
			night_horizon = "#fff",
			indoors = "#3b3b3b",
			fog_sun_tint = "#263965",
			fog_moon_tint = "#263965",
			fog_tint_type = "custom",
		},
        fog = {
            fog_start = 0.05,
            fog_distance = 180,
        },
	},
})

br_core.register_biome({
    level = level,
    desc = "Level 84 fields",
    segheight = 8,
    danger = 0,
    on_generate = nil,
    prevalence = 3,
    can_generate = function(seg_pos)
        return true
    end,
    schems = {
        {name=sch("84_fill_10_0"), free_rotation=true, vertical_segments={1},},
        {name=sch("84_field_0"), free_rotation=true, vertical_segments={0,1}, prevalence=6, skip_above = 7},
        {name=sch("84_field_1"), free_rotation=true, vertical_segments={0,1}, prevalence=1, skip_above = 7},
        {name=sch("84_field_2"), free_rotation=true, vertical_segments={0,1}, prevalence=1, skip_above = 7},
        {name=sch("84_field_3"), free_rotation=true, vertical_segments={0,1}, prevalence=1, skip_above = 7},
        {name=sch("84_field_4"), free_rotation=true, vertical_segments={0,1}, prevalence=4, skip_above = 7},
        {name=sch("84_field_5"), free_rotation=true, vertical_segments={0,1}, prevalence=9, skip_above = 7},
        {name=sch("84_field_6"), free_rotation=true, vertical_segments={0,1}, prevalence=9, skip_above = 7},
        {name=sch("84_field_7"), free_rotation=true, vertical_segments={0,1}, prevalence=9, skip_above = 7},
        {name=sch("84_field_wc_0"), free_rotation=true, vertical_segments={0,1}, skip_above = 7},
    },
})
br_core.register_biome({
    level = level,
    desc = "Level 84 canal",
    name = "canal_north",
    segheight = 8,
    danger = 0,
    on_generate = nil,
    can_generate = function(seg_pos)
        return false
    end,
    schems = {
        {name=sch("84_canal_n_0"), rotation=0, vertical_segments={1}, skip_above=8},
        {name=sch("84_canal_n_1"), rotation=0, vertical_segments={1}, skip_above=8,
            can_generate = function(pos)
                return (pos.x % 2 == 0) and (pos.z % 2 == 0)
            end
        },
        {name=sch("84_canal_n_0"), rotation=2, vertical_segments={1}, skip_above=8},
        {name=sch("84_canal_n_1"), rotation=2, vertical_segments={1}, skip_above=8,
            can_generate = function(pos)
                return (pos.x % 2 == 0) and (pos.z % 2 == 0)
            end
        },
    },
})
br_core.register_biome({
    level = level,
    desc = "Level 84 canal",
    name = "canal_east",
    segheight = 8,
    danger = 0,
    on_generate = nil,
    can_generate = function(seg_pos)
        return false
    end,
    schems = {
        {name=sch("84_canal_n_0"), rotation=1, vertical_segments={1}, skip_above=8},
        {name=sch("84_canal_n_1"), rotation=1, vertical_segments={1}, skip_above=8,
            can_generate = function(pos)
                return (pos.x % 2 == 0) and (pos.z % 2 == 0)
            end
        },
    {name=sch("84_canal_n_0"), rotation=3, vertical_segments={1}, skip_above=8},
        {name=sch("84_canal_n_1"), rotation=3, vertical_segments={1}, skip_above=8,
            can_generate = function(pos)
                return (pos.x % 2 == 0) and (pos.z % 2 == 0)
            end
        },
    },
})
br_core.register_biome({
    level = level,
    desc = "Level 84 canal",
    name = "canal_intersection",
    segheight = 8,
    danger = 0,
    on_generate = nil,
    can_generate = function(seg_pos)
        return false
    end,
    schems = {
        {name=sch("84_canal_x_0"), rotation=0, vertical_segments={1}, skip_above=8},
    },
})

br_core.register_biome({
    level = level,
    desc = "Level 84 conc",
    segheight = 8,
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    can_generate = function(seg_pos)
        return true
    end,
    schems = {
        {name=sch("84_fill_10_0"), free_rotation=true, vertical_segments={1},},
        {name=sch("84_field_conc_0"), free_rotation=true, vertical_segments={0,1}, skip_above = 7, prevalence=2},
        {name=sch("84_field_conc_1"), free_rotation=true, vertical_segments={0,1}, skip_above = 7, prevalence=2},
        {name=sch("84_field_conc_2"), free_rotation=true, vertical_segments={0,1}, skip_above = 7, prevalence=2},

        {name=sch("84_build_base_0"), vertical_segments={0,1}},
        {name=sch("84_build_base_1"), vertical_segments={0,1}},
        {name=sch("84_build_base_2"), vertical_segments={0,1}},
        {name=sch("84_build_base_3"), vertical_segments={0,1}},
        {name=sch("84_build_base_4"), vertical_segments={0,1}},
        {name=sch("84_build_floor_even_0"), vertical_segments={0,0,1,1,1,1,1,1,0,0}, prevalence=10},
        {name=sch("84_build_floor_even_1"), vertical_segments={0,0,1,1,1,1,1,1,0,0}, prevalence=10},
        {name=sch("84_build_floor_even_2"), vertical_segments={0,0,1,1,1,1,1,1,0,0}, prevalence=10},
        {name=sch("84_build_floor_even_3"), vertical_segments={0,0,1,1,1,1,1,1,0,0}, prevalence=10},
        {name=sch("84_build_floor_even_4"), vertical_segments={0,0,1,1,1,1,1,1,0,0}, prevalence=10},
        {name=sch("84_build_floor_even_5"), vertical_segments={0,0,1,1,1,1,1,1,0,0}, prevalence=10},
        {name=sch("84_build_floor_even_0_portal"), vertical_segments={0,0,1,1,1,1,1,1,0,0}}, -- red portal
        {name=sch("84_build_floor_even_1_portal"), vertical_segments={0,0,1,1,1,1,1,1,0,0}}, -- red portal
        {name=sch("84_build_floor_even_2_portal"), vertical_segments={0,0,1,1,1,1,1,1,0,0}},
        {name=sch("84_build_floor_even_3_portal"), vertical_segments={0,0,1,1,1,1,1,1,0,0}},
        {name=sch("84_build_floor_even_4_portal"), vertical_segments={0,0,1,1,1,1,1,1,0,0}},
        {name=sch("84_build_floor_even_5_portal"), vertical_segments={0,0,1,1,1,1,1,1,0,0}},
        {name=sch("84_build_floor_end_0"), vertical_segments={0,0,0,1,0,0,0,0,0,0}, skip_above = 5, prevalence=2},
        {name=sch("84_build_floor_end_0"), vertical_segments={0,0,0,0,1,0,0,0,0,0}, skip_above = 4, prevalence=2},
        {name=sch("84_build_floor_end_0"), vertical_segments={0,0,0,0,0,1,0,0,0,0}, skip_above = 3, prevalence=2},
        {name=sch("84_build_floor_end_0"), vertical_segments={0,0,0,0,0,0,1,0,0,0}, skip_above = 2, prevalence=2},
        {name=sch("84_build_floor_end_0"), vertical_segments={0,0,0,0,0,0,0,1,0,0}, skip_above = 1, prevalence=2},
        {name=sch("84_build_floor_end_0"), vertical_segments={0,0,0,0,0,0,0,0,1,0}},
        {name=sch("84_build_floor_end_1"), vertical_segments={0,0,0,1,0,0,0,0,0,0}, skip_above = 5, prevalence=2},
        {name=sch("84_build_floor_end_1"), vertical_segments={0,0,0,0,1,0,0,0,0,0}, skip_above = 4, prevalence=2},
        {name=sch("84_build_floor_end_1"), vertical_segments={0,0,0,0,0,1,0,0,0,0}, skip_above = 3, prevalence=2},
        {name=sch("84_build_floor_end_1"), vertical_segments={0,0,0,0,0,0,1,0,0,0}, skip_above = 2, prevalence=2},
        {name=sch("84_build_floor_end_1"), vertical_segments={0,0,0,0,0,0,0,1,0,0}, skip_above = 1, prevalence=2},
        {name=sch("84_build_floor_end_1"), vertical_segments={0,0,0,0,0,0,0,0,1,0}},
        {name=sch("84_build_floor_end_2"), vertical_segments={0,0,0,1,0,0,0,0,0,0}, skip_above = 5, prevalence=2},
        {name=sch("84_build_floor_end_2"), vertical_segments={0,0,0,0,1,0,0,0,0,0}, skip_above = 4, prevalence=2},
        {name=sch("84_build_floor_end_2"), vertical_segments={0,0,0,0,0,1,0,0,0,0}, skip_above = 3, prevalence=2},
        {name=sch("84_build_floor_end_2"), vertical_segments={0,0,0,0,0,0,1,0,0,0}, skip_above = 2, prevalence=2},
        {name=sch("84_build_floor_end_2"), vertical_segments={0,0,0,0,0,0,0,1,0,0}, skip_above = 1, prevalence=2},
        {name=sch("84_build_floor_end_2"), vertical_segments={0,0,0,0,0,0,0,0,1,0}},
    },
})

local pl = {}
br_core.register_on_level_enter(function(player, from_level, to_level)
    if to_level == level then
        pl[player] = true
        player:override_day_night_ratio(0.5)
    end
end)
br_core.register_on_level_exit(function(player, from_level, to_level)
    if to_level == level then
        pl[player] = nil
        player:override_day_night_ratio()
    end
end)


local _timer = -1
minetest.register_globalstep(function(dtime)
    for player,_ in pairs(pl) do
        if player and player.is_player and player:is_player() then
            -- add rain particles
        end
    end
end)

-- junk and occasional supplies
br_core.set_loot_table(level, 0, {
    node_names = {"br_core:loot_crate"},
    max_items = 4,
    items = {
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.food(76),
        br_core.loot.list.food(76),
        br_core.loot.list.drinks(65),
        br_core.loot.list.drinks(65),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- food
br_core.set_loot_table(level, 1, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.food(54),
        br_core.loot.list.food(54),
        br_core.loot.list.food(54),
    },
})
-- drinks
br_core.set_loot_table(level, 2, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.drinks(34),
        br_core.loot.list.drinks(34),
        br_core.loot.list.drinks(34),
    },
})
-- tools and supplies
br_core.set_loot_table(level, 3, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.tools(8),
        br_core.loot.list.junk(3),
        br_core.loot.list.junk(3),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- jackpot
br_core.set_loot_table(level, 4, {
    node_names = {"br_core:loot_crate"},
    max_items = 16,
    items = {
        br_core.loot.list.food(16),
        br_core.loot.list.food(16),
        br_core.loot.list.drinks(8),
        br_core.loot.list.drinks(8),
        br_core.loot.list.tools(4),
        {items = {"br_core:key_2 1"}, rarity = 8},
        {items = {"br_core:key_3 1"}, rarity = 14},
        {items = {"br_core:key_4 1"}, rarity = 14},
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
    },
})
-- keys
br_core.set_loot_table(level, 8, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        {items = {"br_core:key_2 1"}, rarity = 8},
        {items = {"br_core:key_3 1"}, rarity = 14},
        {items = {"br_core:key_4 1"}, rarity = 14},
        br_core.loot.list.junk(8),
        br_core.loot.list.junk(8),
        br_core.loot.list.tools(8),
    },
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_0",
    node_name = "br_core:loot_crate_0",
    rarity = 70,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_1",
    node_name = "br_core:loot_crate_1",
    rarity = 66,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_2",
    node_name = "br_core:loot_crate_2",
    rarity = 54,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_3",
    node_name = "br_core:loot_crate_3",
    rarity = 54,
})
