
local s = 16

local a, b, c, d, e, f = 0, 0, 0, 0, 0, 0

local catwalk_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, ( 6)/16, (-8)/16,
            ( 8)/16, ( 8)/16, ( 8)/16,
        },
    },
}
core.register_node("br_core:catwalk", {
    description = "br_core:catwalk",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_catwalk.png^[multiply:".."#7e7d7d".."^(br_meta_overlay_dirt_1.png^[multiply:#766353^[opacity:50)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    paramtype = "light",
    sunlight_propagates = true,
    node_box = catwalk_box,
    sounds = br_sounds.steel(),
})
core.register_node("br_core:catwalk_WE", {
    description = "br_core:catwalk_WE",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "(br_meta_catwalk.png^[multiply:".."#7e7d7d".."^[transformFXR270)^(br_meta_overlay_dirt_1.png^[multiply:#766353^[opacity:50)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    paramtype = "light",
    sunlight_propagates = true,
    node_box = catwalk_box,
    sounds = br_sounds.steel(),
})

local catwalk_box_low = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, (-10)/16, (-8)/16,
            ( 8)/16, (-7.99)/16, ( 8)/16,
        },
    },
}
core.register_node("br_core:catwalk_low", {
    description = "br_core:catwalk_low",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_catwalk.png^[multiply:".."#7e7d7d".."^(br_meta_overlay_dirt_1.png^[multiply:#766353^[opacity:50)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    paramtype = "light",
    sunlight_propagates = true,
    node_box = catwalk_box_low,
    sounds = br_sounds.steel(),
})

local catwalk_stair_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, ( 6)/16, (-4)/16,
            ( 8)/16, ( 8-0.1)/16, ( 8)/16,
        },
        {
            (-8)/16, ( 6-8)/16, (-12+.1)/16,
            ( 8)/16, ( 8-8-0.1)/16, (  0.1)/16,
        },
        -- join
        {
            (-6)/16, ( 0)/16, (-1)/16,
            (-4)/16, ( 6)/16, ( 0)/16,
        },
        {
            ( 4)/16, ( 0)/16, (-1)/16,
            ( 6)/16, ( 6)/16, ( 0)/16,
        },
        -- join to below
        {
            (-6)/16, (-8)/16, (-9)/16,
            (-4)/16, (-2)/16,  (-8)/16,
        },
        {
            ( 4)/16, (-8)/16, (-9)/16,
            ( 6)/16, (-2)/16,  (-8)/16,
        },
    },
}

core.register_node("br_core:catwalk_stair", {
    description = "br_core:catwalk_stair",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_catwalk.png^[multiply:".."#7e7d7d".."^(br_meta_overlay_dirt_1.png^[multiply:#766353^[opacity:50)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    paramtype = "light",
    sunlight_propagates = true,
    node_box = catwalk_stair_box,
    paramtype2 = "facedir",
    sounds = br_sounds.steel(),
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})

for variant, color in pairs(br_core.node_colors) do
    core.register_node("br_core:catwalk_stair_" .. variant .. "_0", {
        description = "br_core:catwalk_stair_" .. variant .. "_0",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "br_meta_catwalk.png^[multiply:"..color.main.."^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:50)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        paramtype = "light",
        sunlight_propagates = true,
        node_box = catwalk_stair_box,
        paramtype2 = "facedir",
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    })
    aom_tcraft.register_craft({
        output = "br_core:catwalk_stair_" .. variant .. "_0",
        items = {unobtainable = 1}
    })
    core.register_node("br_core:catwalk_" .. variant .. "_0", {
        description = "br_core:catwalk_" .. variant .. "_0",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "br_meta_catwalk.png^[multiply:"..color.main.."^(br_meta_overlay_dirt_5.png^[multiply:#222^[opacity:50)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        paramtype = "light",
        sunlight_propagates = true,
        node_box = catwalk_box,
        sounds = br_sounds.steel(),
    })
    aom_tcraft.register_craft({
        output = "br_core:catwalk_" .. variant .. "_0",
        items = {unobtainable = 1}
    })
end

local handrail_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, ( 6)/16, ( 7)/16,
            ( 8)/16, ( 8)/16, ( 9)/16,
        },
        {
            (-8)/16, ( 2)/16, ( 7)/16,
            ( 8)/16, ( 0)/16, ( 9)/16,
        },
        {
            (-1)/16, (-10)/16, ( 6)/16,
            ( 1)/16, (  7)/16, ( 8.1)/16,
        },
    },
}
for i, o in pairs(handrail_box.fixed) do
    for k, p in pairs(o) do
        handrail_box.fixed[i][k] = handrail_box.fixed[i][k] - 0.001
    end
end
local handrail_box_simple = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, (-8)/16, ( 7)/16,
            ( 8)/16, ( 8)/16, ( 8)/16,
        },
    },
}
core.register_node("br_core:handrail", {
    description = "br_core:handrail",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 0, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "(br_meta_blank.png^[multiply:".."#7e7d7d".."^[transformFXR270)^(br_meta_overlay_dirt_1.png^[multiply:#766353^[opacity:50)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    node_box = handrail_box,
    collision_box = handrail_box_simple,
    selection_box = handrail_box_simple,
    paramtype2 = "facedir",
    paramtype = "light",
    sunlight_propagates = true,
    sounds = br_sounds.steel(),
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
local handrail_end_box = {
    type = "fixed",
    fixed = {
        {
            ( 7)/16, (-10)/16, ( 7)/16,
            ( 9)/16, (  8)/16, ( 9)/16,
        },
    },
}
core.register_node("br_core:handrail_end", {
    description = "br_core:handrail_end",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 0, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "(br_meta_blank.png^[multiply:".."#7e7d7d".."^[transformFXR270)^(br_meta_overlay_dirt_1.png^[multiply:#766353^[opacity:50)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    node_box = handrail_end_box,
    walkable = false,
    paramtype2 = "facedir",
    paramtype = "light",
    sunlight_propagates = true,
    sounds = br_sounds.steel(),
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})

for i, k in pairs({"right", "left"}) do
    core.register_node("br_core:handrail_diagonal_"..k, {
        description = "br_core:handrail_diagonal_"..k,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 0, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {
            {
                name = "[combine:16x16:-126,-126=" ..
                "(br_meta_blank.png\\^\\[multiply\\:".."#7e7d7d"..
                "\\^\\[transformFXR270)\\^(br_meta_overlay_dirt_1.png\\^\\[multiply\\:#766353\\^\\[opacity\\:50)",
                align_style = "world",
                scale = 16,
                backface_culling = true,
            },
            {
                name = "[combine:16x16:-126,-126=" ..
                "(br_meta_blank.png\\^\\[multiply\\:".."#7e7d7d"..
                "\\^\\[transformFXR270)\\^(br_meta_overlay_dirt_1.png\\^\\[multiply\\:#766353\\^\\[opacity\\:50)",
                align_style = "world",
                scale = 16,
                backface_culling = true,
            },
        },
        drawtype = "mesh",
        mesh = "br_handrail_diagonal_"..k..".obj",
        collision_box = handrail_box_simple,
        selection_box = handrail_box_simple,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        node_box = handrail_box,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    })
end

for variant, color in pairs(br_core.node_colors) do
    local name

    name = "br_core:handrail_end_"..variant
    core.register_node(name, {
        description = name,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 0, oddly_breakable_by_hand = 2, furniture = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[multiply:"..color.main..--"^[hsl:0:-30:0"..
            "^[transformFXR270)^(br_meta_overlay_dirt_5.png^[multiply:#111^[opacity:40)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        node_box = handrail_end_box,
        walkable = false,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    })
    aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})

    name = "br_core:handrail_"..variant
    core.register_node(name, {
        description = name,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 0, oddly_breakable_by_hand = 2, furniture = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[multiply:"..color.main..--"^[hsl:0:-30:0"..
            "^[transformFXR270)^(br_meta_overlay_dirt_5.png^[multiply:#111^[opacity:40)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        node_box = handrail_box,
        collision_box = handrail_box_simple,
        selection_box = handrail_box_simple,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    })
    aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})

    for i, k in pairs({"right", "left"}) do
        name = "br_core:handrail_diagonal_"..k.."_"..variant
        local tile = {
            name = "[combine:16x16:-126,-126=" ..
            "(br_meta_blank.png\\^\\[multiply\\:"..color.main..--"\\^\\[hsl\\:0\\:-30\\:0"..
            "\\^\\[transformFXR270)\\^(br_meta_overlay_dirt_5.png\\^\\[multiply\\:#111\\^\\[opacity\\:40)",
            align_style = "world",
            scale = 16,
            backface_culling = true,
        }
        core.register_node(name, {
            description = name,
            pointable = br_core.nodes_pointable or false,
            groups = { solid = 1, full_solid = 0, oddly_breakable_by_hand = 2, furniture = 1 },
            tiles = {
                tile, tile,
            },
            drawtype = "mesh",
            mesh = "br_handrail_diagonal_"..k..".obj",
            collision_box = handrail_box_simple,
            selection_box = handrail_box_simple,
            paramtype2 = "facedir",
            paramtype = "light",
            sunlight_propagates = true,
            node_box = handrail_box,
            sounds = br_sounds.steel(),
            on_place = function(itemstack, placer, pointed_thing)
                return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
            end,
        })
        aom_tcraft.register_craft({output = name, items = {unobtainable = 1}})
    end
end

a = 8
b = 14
c = 7.99

d = 9
e = 12

local table_box_corner = {
    type = "fixed",
    fixed = {
        {
            -a/s,   7/s, -a/s,
             a/s,   c/s,  a/s,
        },
        { -- corner
            -7/s,  4/s, -7/s,
             a/s,  7/s,  a/s,
        },
        { -- leg
            -7/s,  -8/s, -7/s,
            -4/s,   4/s, -4/s,
        },
    },
}

local table_box_side = {
    type = "fixed",
    fixed = {
        { -- top
            -a/s,  7/s, -a/s,
             a/s,  c/s,  a/s,
        },
        { -- side
            -8/s,  4/s, -7/s,
             8/s,  7/s,  8/s,
        },
    },
}

local table_box_end = {
    type = "fixed",
    fixed = {
        { -- top
            -b/s, 7/s, -b/s,
             b/s,   c/s,  a/s,
        },
        { -- corner
            -e/s,  4/s, -e/s,
             e/s,  7/s,  a/s,
        },
        { -- leg
            -e/s,  -8/s, -e/s,
            -d/s,  4/s,  -d/s,
        },
        { -- leg
            d/s, -8/s, -e/s,
            e/s,  4/s, -d/s,
        },
    },
}

local table_box_middle = {
    type = "fixed",
    fixed = {
        { -- top
            -a/s, 7/s, -b/s,
             a/s, c/s,  b/s,
        },
        { -- side
            -a/s,  4/s, -e/s,
             a/s,  7/s,  e/s,
        },
    },
}

for variant, color in pairs(br_core.node_colors) do
    core.register_node("br_core:table_" .. variant .. "_corner_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, furniture = 1, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[multiply:" .. color.main .. "^[hsl:0:-30:0)" ..
            "^(br_meta_overlay_dirt_2.png^[multiply:" .. color.lowlight .. "^[opacity:20)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        node_box = table_box_corner,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, nil)
        end,
    })
    aom_tcraft.register_craft({
        output = "br_core:table_" .. variant .. "_corner_0",
        items = {unobtainable = 1}
    })

    core.register_node("br_core:table_" .. variant .. "_side_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, furniture = 1, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[multiply:" .. color.main .. "^[hsl:0:-30:0)" ..
            "^(br_meta_overlay_dirt_2.png^[multiply:" .. color.lowlight .. "^[opacity:20)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        node_box = table_box_side,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, nil)
        end,
    })
    aom_tcraft.register_craft({
        output = "br_core:table_" .. variant .. "_side_0",
        items = {unobtainable = 1}
    })

    core.register_node("br_core:table_" .. variant .. "_end_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, furniture = 1, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[multiply:" .. color.main .. "^[hsl:0:-30:0)" ..
            "^(br_meta_overlay_dirt_2.png^[multiply:" .. color.lowlight .. "^[opacity:20)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        node_box = table_box_end,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, nil)
        end,
    })
    aom_tcraft.register_craft({
        output = "br_core:table_" .. variant .. "_end_0",
        items = {unobtainable = 1}
    })

    core.register_node("br_core:table_" .. variant .. "_middle_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, furniture = 1, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[multiply:" .. color.main .. "^[hsl:0:-30:0)" ..
            "^(br_meta_overlay_dirt_2.png^[multiply:" .. color.lowlight .. "^[opacity:20)",
            align_style = "world",
            scale = 16,
        }},
        drawtype = "nodebox",
        node_box = table_box_middle,
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        sounds = br_sounds.steel(),
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, nil)
        end,
    })
    aom_tcraft.register_craft({
        output = "br_core:table_" .. variant .. "_middle_0",
        items = {unobtainable = 1}
    })
end

local chair_box = {
    type = "fixed",
    fixed = {
        {
            -4/s, -8/s, -4/s,
             4/s,  2/s,  4/s,
        }
    }
}
for variant, color in pairs(br_core.node_colors) do
    core.register_node("br_core:chair_" .. variant .. "_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1, furniture = 1, },
        tiles = {{
            name = "[combine:64x64:0,0=br_meta_blank.png^[multiply:" .. color.main .. "^[hsl:0:-30:0" ..
            "^([combine:64x64:-64,-128=br_meta_overlay_dirt_2.png^[multiply:" .. color.lowlight .."^[opacity:20)",
			backface_culling = true,
        }},
        drawtype = "mesh",
        mesh = "br_chair_0.obj",
        selection_box = chair_box,
        collision_box = chair_box,
        paramtype = "light",
        paramtype2 = "degrotate",
        sunlight_propagates = true,
        sounds = br_sounds.carpet(),
        -- on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        -- end,
        on_place = function(itemstack, placer, pointed_thing)
            local yaw = 0
            if core.is_player(placer) then
                local lookyaw = placer:get_look_horizontal()
                yaw = math.round(math.abs(lookyaw * 0.5 / math.pi) * 240) % 240
            end
            core.item_place_node(itemstack, placer, pointed_thing, yaw)
            return itemstack
        end,
    })
end

local function update_node_inv_formspec(pos, background)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()
    inv:set_size("main", 4*4)
    meta:set_string("formspec",
        "formspec_version[3]"..
        "size[13,9]"..
        "container[2,0]"..
        (background or "background[0,0;9,9;br_crate_background.png]")..
        "bgcolor[#ffffff00]"..
        "listcolors[#f7ebeb20;#f7ebeb00]"..
        "list[context;main;2.1,1;4,4;]"..
        "listring[context;main]"..
        "listring[current_player;main]"..
        br_core.get_inventory_list({x=0.85,y=6.2})..
        "container_end[]"
    )
end

local function _loot_init(pos, level, tier)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()
    inv:set_size("main", 4*4)
    update_node_inv_formspec(pos)
end

core.register_node("br_core:drawers_0", {
    description = "",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1, furniture = 1, },
    tiles = {{
        name = "br_drawers_0.png^[multiply:#67524b^(br_meta_overlay_dirt_3.png^[multiply:#323^[opacity:30)",
        backface_culling = true,
    }},
    drawtype = "mesh",
    mesh = "br_drawers_0.obj",
    paramtype = "light",
    paramtype2 = "facedir",
    sunlight_propagates = true,
    sounds = br_sounds.carpet(),
    on_timer = br_core.loot_refresh,
    on_rightclick = br_core.flags.loot_crates and function(pos, node, clicker, itemstack, pointed_thing)
        br_core.loot_refresh_start(pos)
        update_node_inv_formspec(pos)
    end or nil,
    _loot_init = _loot_init,
})

local fridge_box = {
    type = "fixed",
    fixed = {
        {
            -8/s,  -8/s, -7/s,
             8/s, 1+8/s,  8/s,
        },
    },
}
core.register_node("br_core:fridge_0", {
    description = "",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1, furniture = 1, },
    tiles = {{
        name = "br_fridge_0.png^[multiply:#ddd^(br_meta_overlay_dirt_3.png^[multiply:#323^[opacity:20)",
        backface_culling = true,
    }},
    drawtype = "mesh",
    mesh = "br_fridge_0.obj",
    paramtype = "light",
    paramtype2 = "facedir",
    sunlight_propagates = true,
    selection_box = fridge_box,
    collision_box = fridge_box,
    sounds = br_sounds.carpet(),
    on_timer = br_core.loot_refresh,
    on_rightclick = br_core.flags.loot_crates and function(pos, node, clicker, itemstack, pointed_thing)
        br_core.loot_refresh_start(pos)
        update_node_inv_formspec(pos)
    end or nil,
    _loot_init = _loot_init,
})

for variant, color in pairs(br_core.node_colors) do
    local dirt = "^([combine:16x16:0,-16=br_meta_overlay_dirt_3.png^[multiply:#323^[opacity:20)"
    local side = {name="br_locker_side_0.png^[multiply:" .. color.main ..
    "^[hsl:0:-30:0" .. dirt}
    core.register_node("br_core:locker_"..variant.."_bottom_0", {
        description = "",
        pointable = br_core.dev_mode or false,
        groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1, furniture = 1, },
        tiles = {
            side,
        },
        drawtype = "normal",
        paramtype2 = "facedir",
        sounds = br_sounds.carpet(),
        on_rightclick = br_core.loot_refresh_start,
        on_timer = br_core.loot_refresh,
    })
    aom_tcraft.register_craft({
        output = "br_core:locker_"..variant.."_bottom_0",
        items = {unobtainable = 1}
    })

    core.register_node("br_core:locker_"..variant.."_top_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, oddly_breakable_by_hand = 2, cracky = 1, furniture = 1, },
        tiles = {
            side,
            side,
            side,
            side,
            side,
            "br_locker_top_0.png^[multiply:" .. color.main .. "^[hsl:0:-30:0" .. dirt,
        },
        drawtype = "normal",
        paramtype2 = "facedir",
        sounds = br_sounds.carpet(),
        on_timer = br_core.loot_refresh,
        on_rightclick = br_core.flags.loot_crates and function(pos, node, clicker, itemstack, pointed_thing)
            br_core.loot_refresh_start(pos)
            update_node_inv_formspec(pos)
        end or nil,
        _loot_init = _loot_init,
    })
    aom_tcraft.register_craft({
        output = "br_core:locker_"..variant.."_top_0",
        items = {unobtainable = 1}
    })
end

do
    local dirt = "^([combine:32x32:0,0=br_meta_overlay_dirt_3.png^[multiply:#222^[opacity:20)"
    core.register_node("br_core:oven_0", {
        description = "",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, oddly_breakable_by_hand = 2, furniture = 1, },
        drawtype = "mesh",
        mesh = "br_oven_0.obj",
        tiles = {{
            name = "br_oven_0.png^[multiply:#eee" .. dirt,
			backface_culling = true,
        }},
        use_texture_alpha = "opaque",
        sounds = br_sounds.default(),
        selection_box = {
            type = "fixed",
            fixed = {
                {
                    (-8)/16, (-8)/16, (-8)/16,
                    ( 8)/16, ( 7)/16, ( 8)/16,
                },
                {
                    (-8)/16, ( 7)/16, ( 7)/16,
                    ( 8)/16, ( 11)/16, ( 8)/16,
                },
            },
        },
        paramtype2 = "facedir",
        -- paramtype = "light",
    })
    aom_tcraft.register_craft({output = "br_core:oven_0", items = {unobtainable = 1}})
end