

local color = { main="#756052", alt="#fff",    outline="#877263", highlight="#877767", lowlight="#655052", raw="#6d6d73"}
core.register_node("br_core:loot_crate", {
    description = "br_core:loot_crate\nThe actual storage part of the loot system",
    pointable = true,
    groups = { solid = 1, full_solid = 1, loot_crate = 1, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "(br_meta_blank.png^[colorize:"..(color.main)..":255"..
        "^(br_meta_overlay_dirt_3.png^[multiply:#753^[opacity:50))"..
        "^(br_meta_overlay_crisscross_0.png^[multiply:"..color.outline.."".."^[opacity:80)"..
        -- "^(br_meta_overlay_crisscross_1.png^[multiply:"..color.outline.."".."^[opacity:255)"..
        "^(br_meta_overlay_crisscross_2.png^[multiply:"..color.outline..")",
        align_style = "world",
        scale = 16,
    }},
    on_rightclick = br_core.loot_refresh_start,
    on_timer = br_core.loot_refresh,
    sounds = br_sounds.default(),
})

core.register_node("br_core:loot_crate_white", {
    description = "br_core:loot_crate\nThe actual storage part of the loot system",
    pointable = true,
    groups = { solid = 1, full_solid = 1, loot_crate = 1, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "(br_meta_blank.png^[colorize:#eee:255"..
        "^(br_meta_overlay_dirt_3.png^[multiply:#ddd^[opacity:50))"..
        "^(br_meta_overlay_crisscross_0.png^[multiply:#fff^[opacity:80)"..
        -- "^(br_meta_overlay_crisscross_1.png^[multiply:"..color.outline.."".."^[opacity:255)"..
        "^(br_meta_overlay_crisscross_2.png^[multiply:#fff)",
        align_style = "world",
        scale = 16,
    }},
    on_rightclick = br_core.loot_refresh_start,
    on_timer = br_core.loot_refresh,
    sounds = br_sounds.default(),
})


for i, c in pairs({
    "#453e5e",
    "#7e5499",
    "#d9479e",
    "#e67d6c",
    "#f5ce7c",
    "#f98642",
    "#e9d52d",
    "#a9e92d",
    "#29c530",
}) do
    core.register_node("br_core:loot_area_"..(i-1), {
        description = "br_core:loot_area_"..(i-1).."\nOffers a place to spawn loot",
        pointable = br_core.dev_mode or false,
        groups = { not_in_creative_inventory = (i==1) and 0 or 1, clear_after_mapgen = 1, dig_immediate = 3 },
        drawtype = "glasslike",
        tiles = { 'br_loot_area.png^[multiply:'..c },
        use_texture_alpha = "clip",
        sounds = {},
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        drop = "br_core:loot_area_0",
        _loot_tier = i-1,
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            local k = core.registered_nodes[node.name]._loot_tier or 0
            node.name = "br_core:loot_area_"..((k+1)%9)
            core.set_node(pos, node)
        end,
    })

    core.register_node("br_core:loot_injector_"..(i-1), {
        description = "br_core:loot_injector_"..(i-1).."\nAlways spawns loot in inventory facedir points at",
        pointable = br_core.dev_mode or false,
        groups = { not_in_creative_inventory = (i==1) and 0 or 1, dig_immediate = 3 },
        drawtype = br_core.dev_mode and "nodebox" or "airlike" and "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                -0.5, -0.5, 0.3,
                 0.5,  0.5, 0.5,
            }
        },
        selection_box = {
            type = "fixed",
            fixed = {
                -0.3, -0.3, 0.3,
                 0.3,  0.3, 0.5,
            }
        },
        tiles = { 'br_loot_area.png^[multiply:'..c },
        use_texture_alpha = "clip",
        sounds = {},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        walkable = false,
        drop = "br_core:loot_injector_0",
        _loot_tier = i-1,
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.rotate_and_place_against(itemstack, placer, pointed_thing, {})
        end,
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            local k = core.registered_nodes[node.name]._loot_tier or 0
            node.name = "br_core:loot_injector_"..((k+1)%9)
            core.set_node(pos, node)
        end,
    })
    br_core.register_on_generate_node("br_core:loot_injector_"..(i-1), br_core.loot_injector_init)

    core.register_node("br_core:loot_crate_"..(i-1), {
        description = "br_core:loot_crate_"..(i-1),
        pointable = br_core.dev_mode or false,
        groups = { not_in_creative_inventory = 1, init_loot_crate = 1, dig_immediate = 3 },
        drawtype = (br_core.dev_mode and "glasslike") or "airlike",
        tiles = { 'br_loot_area.png^[multiply:'..c .. "^[noalpha" },
        use_texture_alpha = "clip",
        sounds = {},
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        _loot_tier = i-1,
    })
    br_core.register_on_generate_node("br_core:loot_crate_"..(i-1), br_core.loot_crate_init)
end

-- core.register_abm({
--     nodenames = {"group:init_loot_crate"},
--     interval = 1,
--     chance = 1,
--     action = function(pos, node)
--     end,
-- })
