local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local debug = br_core.debug

br_core.node_tile = {}

local function register_shapes(...)
    return aom_util.register_all_shapes(...)
end

local has_aom_tcraft = core.get_modpath("aom_tcraft") ~= nil
local function register_craft(...)
    if has_aom_tcraft then
        return aom_tcraft.register_craft(...)
    end
end

-- adds a variant of a node by overlaying
local function add_overlay_variant(name, overlay_tex, variant_type, flags)
    flags = flags or {}
    local node_name = name.."_"..variant_type
    local node = core.registered_nodes[name]
    local copy = table.copy(node)
    if copy.tiles[1].name then
        copy.tiles[1].name = "("..node.tiles[1].name..")^"..overlay_tex
    else
        copy.tiles[1] = "("..node.tiles[1]..")^"..overlay_tex
    end
    copy.description = node.description.."_"..variant_type
    core.register_node(node_name, copy)
    if flags.make_shapes then register_shapes(node_name) end
end

core.register_node("br_core:carpet_0", {
    description = "br_core:carpet_0",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = { "br_".."carpet_0.png" },
    sounds = br_sounds.carpet(),
}) register_shapes("br_core:carpet_0")

core.register_node("br_core:wallpaper_0", {
    description = "br_core:wallpaper_0",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = { "br_".."wallpaper_0.png" },
    sounds = br_sounds.carpet(),
}) add_overlay_variant("br_core:wallpaper_0", "(br_skirting_board_0.png^[sheet:16x16:0,0^[multiply:#d9d8c4)", "skirting", {})

-- not actually white, but close
core.register_node('br_core:white', {
    description = 'br_core:white',
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2 },
    tiles = { '(br_white.png)'..(br_core.dev_mode and '^(br_barrier.png^[colorize:#aaa:255)' or "")},
    sunlight_propagates = true,
    sounds = br_sounds.carpet(),
    paramtype = "light",
    light_source = 14,
}) register_shapes("br_core:white")
core.register_node('br_core:black', {
    description = 'br_core:black',
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2 },
    tiles = { '(br_white.png^[colorize:#000:255)'..(br_core.dev_mode and '^(br_barrier.png^[colorize:#aaa:255)' or "")},
    sunlight_propagates = false,
    sounds = br_sounds.carpet(),
    paramtype = "light",
}) register_shapes("br_core:black")


core.register_node("br_core:placeholder", {
    description = S("Placeholder Node"),
    groups = { solid = 1, unbreakable = 1, },
    tiles = {
        {
            name = "br_core_placeholder_16x.png^[multiply:#888",
            align_style = "world", scale = 16,
        },
    },
    sunlight_propagates = false,
})

core.register_node('br_core:barrier', {
    description = 'barrier',
    pointable = br_core.dev_mode or false,
    groups = { oddly_breakable_by_hand = 2 },
    drawtype = (br_core.dev_mode and "glasslike") or "airlike",
    tiles = { (br_core.dev_mode and 'br_barrier.png') or "blank.png" },
    use_texture_alpha = "clip",
    sunlight_propagates = true,
    paramtype = "light",
}) register_shapes("br_core:barrier")

core.register_node('br_core:light_diffuse', {
    description = 'barrier',
    pointable = br_core.dev_mode or false,
    groups = { oddly_breakable_by_hand = 2 },
    drawtype = (br_core.dev_mode and "glasslike") or "airlike",
    tiles = { 'br_barrier.png^[colorize:#339:255' },
    use_texture_alpha = "clip",
    walkable = false,
    paramtype = "light",
})
core.register_node('br_core:fog_blue', {
    description = 'br_core:fog_blue',
    pointable = br_core.nodes_pointable or false,
    groups = { oddly_breakable_by_hand = 2 },
    drawtype = "liquid",
    tiles = {
        {name='(br_meta_blank.png^[colorize:#3383a6:255'..
        "^(br_meta_overlay_dirt_2.png^[colorize:#ffffff03:255))^[opacity:220", backface_culling=true, align_style="world", scale=16},
        {name='br_meta_blank.png^[colorize:#33b3f6e0:255', backface_culling=true, align_style="world", scale=16},
        {name='blank.png^[colorize:#33436600:255', backface_culling=true},
    },
    use_texture_alpha = "blend",
    sunlight_propagates = true,
    paramtype = "light",
}) register_shapes("br_core:fog_blue")

-- add hardcoded shading back in, but do it in a way that doesn't suck
-- this is due to Luanti hardcoding nodes to have a certain discoloration
-- to mimic directional shading, that cannot be disabled and prevents the
-- creation of white ceilings, since the brightest color you can achieve for
-- the underside of a node is #8a8a97 (VERY dark) so we have to use light_source = 1
-- and use this jank workaround
local shaders = {"#c8c8c8", "#eee", "#ddd"}
local engine_shaders = {"#aaa", "#aaaaaf", "#d4d4d9"}
function br_core.shader_unfck(tex, sides)
    local s = sides or engine_shaders
    return {
        {
            name = tex.."^[multiply:#fff",
            align_style = "world",
            scale = 16
        },
        {
            name = tex.."^[multiply:"..s[1],
            align_style = "world",
            scale = 16
        },
        {
            name = tex.."^[multiply:"..s[2],
            align_style = "world",
            scale = 16
        },
        {
            name = tex.."^[multiply:"..s[2],
            align_style = "world",
            scale = 16
        },
        {
            name = tex.."^[multiply:"..s[3],
            align_style = "world",
            scale = 16
        },
        {
            name = tex.."^[multiply:"..s[3],
            align_style = "world",
            scale = 16
        },
    }
end


function br_core.node_tile.concrete(color, flags)
    return {
        name = "br_meta_blank.png^[colorize:"..(color.main)..
        ":255^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
        align_style = "world",
        scale = 16,
    }
end

function br_core.node_tile.concrete_dirty(color, flags)
    return {
        name = "br_meta_blank.png^[colorize:"..(color.main)..
        ":255^(br_meta_overlay_dirt_3.png^[multiply:#223^[opacity:50)",
        align_style = "world",
        scale = 16,
    }
end

function br_core.node_tile.concrete_ruined(color, flags)
    return {
        name = "br_meta_blank.png^[colorize:"..(color.main)..":255"..
        "^(br_meta_overlay_holes_0.png^[multiply:"..(color.raw)..")"..
        "^(br_meta_overlay_dirt_3.png^[multiply:#223^[opacity:50)"..
        "^(br_meta_overlay_rebar_0.png^[opacity:90)",
        align_style = "world",
        scale = 16,
    }
end

-- make tons of variant nodes
for variant, color in pairs(br_core.node_colors) do
    core.register_node("br_core:concrete_"..variant, {
        description = "br_core:concrete_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {br_core.node_tile.concrete(color, nil)},
        sounds = br_sounds.concrete(),
    }) register_shapes("br_core:concrete_"..variant)
    register_craft({output = "br_core:concrete_"..variant, items = {unobtainable = 1}})

    add_overlay_variant("br_core:concrete_"..variant,
        "((br_skirting_board_0.png^[multiply:"..color.alt..")^(br_meta_overlay_dirt_1.png^[multiply:#334^[opacity:10"..
        "^[mask:(br_skirting_board_0.png)))", "skirting", {})
    register_craft({output = "br_core:concrete_"..variant.."_skirting", items = {unobtainable = 1}})

    core.register_node("br_core:concrete_"..variant.."_ls", {
        description = "br_core:concrete_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = br_core.shader_unfck(br_core.node_tile.concrete(color, nil).name),
        sounds = br_sounds.concrete(),
    }) register_shapes("br_core:concrete_"..variant.."_ls")
    register_craft({output = "br_core:concrete_"..variant.."_ls", items = {unobtainable = 1}})

    core.register_node("br_core:concrete_dirty_"..variant, {
        description = "br_core:concrete_dirty_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {br_core.node_tile.concrete_dirty(color, nil)},
        sounds = br_sounds.concrete(),
    }) register_shapes("br_core:concrete_dirty_"..variant)
    register_craft({output = "br_core:concrete_dirty_"..variant, items = {unobtainable = 1}})

    add_overlay_variant("br_core:concrete_dirty_"..variant,
        "(br_skirting_board_0.png^(br_meta_overlay_dirt_1.png^[multiply:#334^[opacity:70))", "skirting", {})
    register_craft({output = "br_core:concrete_dirty_"..variant.."_skirting", items = {unobtainable = 1}})

    core.register_node("br_core:concrete_ruined_"..variant, {
        description = "br_core:concrete_ruined_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {br_core.node_tile.concrete_ruined(color, nil)},
        sounds = br_sounds.concrete(),
    }) register_shapes("br_core:concrete_ruined_"..variant)
    register_craft({output = "br_core:concrete_ruined_"..variant, items = {unobtainable = 1}})

    core.register_node("br_core:carpet_"..variant.."_1", {
        description = "br_core:carpet_"..variant.."_1",
        _name_format = "br_core:carpet_".."[variant]".."_1",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "br_meta_blank.png^[colorize:"..(color.main)..":255"..
            "^(br_meta_overlay_carpet_1.png^[multiply:"..("#112").."^[opacity:6)"..
            "^(br_meta_overlay_carpet_1.png^[multiply:"..(color.outline).."^[opacity:30^[transformR90)",
            align_style = "world",
            scale = 16,
        }},
        sounds = br_sounds.carpet(),
    }) register_shapes("br_core:carpet_"..variant.."_1")
    register_craft({output = "br_core:carpet_"..variant.."_1", items = {unobtainable = 1}})

    core.register_node("br_core:wallpaper_"..variant.."_1", {
        description = "br_core:wallpaper_"..variant.."_1",
        _name_format = "br_core:wallpaper_".."[variant]".."_1",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "br_meta_blank.png^[colorize:"..(color.main)..":255"..
            "^(br_meta_overlay_wallpaper_1.png^[multiply:"..(color.highlight)..")"..
            "^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
            align_style = "world",
            scale = 16,
        }},
        sounds = br_sounds.carpet(),
    }) register_shapes("br_core:wallpaper_"..variant.."_1")
    register_craft({output = "br_core:wallpaper_"..variant.."_1", items = {unobtainable = 1}})

    add_overlay_variant("br_core:wallpaper_"..variant.."_1",
        "((br_skirting_board_0.png^[multiply:"..color.alt..")^(br_meta_overlay_dirt_1.png^[multiply:#334^[opacity:10"..
        "^[mask:(br_skirting_board_0.png)))", "skirting", {})
    register_craft({output = "br_core:wallpaper_"..variant.."_1".."_skirting", items = {unobtainable = 1}})

    core.register_node("br_core:wallpaper_"..variant.."_2", {
        description = "br_core:wallpaper_"..variant.."_2",
        _name_format = "br_core:wallpaper_".."[variant]".."_2",
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "br_meta_blank.png^[colorize:"..(color.main)..":255"..
            "^(br_meta_overlay_wallpaper_2.png^[multiply:"..(color.lowlight)..")"..
            "^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
            align_style = "world",
            scale = 16,
        }},
        sounds = br_sounds.carpet(),
    }) register_shapes("br_core:wallpaper_"..variant.."_2")
    register_craft({output = "br_core:wallpaper_"..variant.."_2", items = {unobtainable = 1}})

    add_overlay_variant("br_core:wallpaper_"..variant.."_2",
        "((br_skirting_board_0.png^[multiply:"..color.alt..")^(br_meta_overlay_dirt_1.png^[multiply:#334^[opacity:10"..
        "^[mask:(br_skirting_board_0.png)))", "skirting", {})
    register_craft({output = "br_core:wallpaper_"..variant.."_2".."_".."skirting", items = {unobtainable = 1}})

    core.register_node("br_core:ceiling_conduit_"..variant, {
        description = "br_core:ceiling_conduit_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = {{
            name = "(br_meta_blank.png^[colorize:"..(color.main)..":255"..
            "^(br_meta_overlay_dirt_3.png^[multiply:#223^[opacity:50))"..
            "^(br_meta_overlay_crisscross_0.png^[multiply:"..color.outline.."".."^[opacity:80)"..
            "^(br_meta_overlay_crisscross_1.png^[multiply:"..color.outline.."".."^[opacity:255)",
            align_style = "world",
            scale = 16,
        }},
        sounds = br_sounds.default(),
    }) register_shapes("br_core:ceiling_conduit_"..variant)
    register_craft({output = "br_core:ceiling_conduit_"..variant, items = {unobtainable = 1}})
    core.register_node("br_core:ceiling_tiles_"..variant, {
        description = "br_core:ceiling_tiles_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = br_core.shader_unfck(
            "br_meta_blank.png^[colorize:"..(color.main)..":255"..
            "^(br_meta_overlay_crisscross_2.png^[multiply:"..color.outline.."^[opacity:100)"..
            "^(br_meta_overlay_dirt_3.png^[multiply:#112^[opacity:10)"),
        sounds = br_sounds.default(),
    })
    register_craft({output = "br_core:ceiling_tiles_"..variant, items = {unobtainable = 1}})
end

for variant, color in pairs(br_core.node_colors) do
    local nodebox = {
        type = "fixed",
        fixed = {
            {
                (-4)/16, (-8)/16, (-4)/16,
                ( 4)/16, ( 8)/16, ( 4)/16,
            },
            {
                (-4)/16, (-4)/16, ( 4)/16,
                ( 4)/16, ( 4)/16, ( 8)/16,
            },
        },
    }
    local pipe = {
        description = "br_core:pipe_connector_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, dig_immediate = (br_core.dev_mode and 3) or 0, pipe = 1, },
        tiles = br_core.shader_unfck("br_meta_blank.png^[colorize:"..(color.main)..":255"..
            "^(br_meta_overlay_dirt_3.png^[multiply:#112^[opacity:10)"),
        drawtype = "nodebox",
        sounds = br_sounds.default(),
        node_box = nodebox,
        selection_box = nodebox,
        connects_to = { "group:pipe" },
        paramtype2 = "facedir",
        paramtype = "light",
        sunlight_propagates = true,
        on_place = function(itemstack, placer, pointed_thing)
            return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
        end,
    }
    core.register_node("br_core:pipe_connector_"..variant, pipe)
    register_craft({output = "br_core:pipe_connector_"..variant, items = {unobtainable = 1}})

    -- pipe connected
    pipe = table.copy(pipe)
    pipe.node_box = {
        type = "fixed",
        fixed = {
            {
                (-4)/16, (-12)/16, (-4)/16,
                ( 4)/16, (  8)/16, ( 4)/16,
            },
        },
    }
    pipe.selection_box = pipe.node_box
    -- core.register_node("br_core:pipe_connector_"..variant, pipe)
end

for variant, color in pairs(br_core.node_colors) do
    local selection_box = {
        type = "fixed",
        fixed = {
            {
                (-8)/16, (-8)/16, (7.9)/16,
                ( 8)/16, ( 8)/16, (7.8)/16,
            },
        },
    }
    for i=0, 9 do
        local name = "br_core:decal_"..variant.."_"..i
        core.register_node(name, {
            description = name,
            pointable = br_core.nodes_pointable or false,
            groups = { dig_immediate = (br_core.dev_mode and 3) or 0 },
            drawtype = "nodebox",
            paramtype2 = "facedir",
            paramtype = "light",
            selection_box = selection_box,
            node_box = selection_box,
            sunlight_propagates = true,
            use_texture_alpha = "clip",
            walkable = false,
            tiles = {{
                name = "(br_number.png^[multiply:"..(color.main).."^[verticalframe:10:"..(i)..")",
            }},
            sounds = br_sounds.default(),
            light_source = 1,
        })
        register_craft({output = name, items = {unobtainable = 1}})
    end

    local name = "br_core:decal_"..variant.."_minus"
    core.register_node(name, {
        description = name,
        pointable = br_core.nodes_pointable or false,
        groups = { dig_immediate = (br_core.dev_mode and 3) or 0 },
        drawtype = "nodebox",
        paramtype2 = "facedir",
        paramtype = "light",
        selection_box = selection_box,
        node_box = selection_box,
        sunlight_propagates = true,
        use_texture_alpha = "clip",
        walkable = false,
        tiles = {{
            name = "(br_number.png^[multiply:"..(color.main)..":255^[verticalframe:10:"..(1)..")^[transformR90",
        }},
        sounds = br_sounds.default(),
        light_source = 1,
    })
    register_craft({output = name, items = {unobtainable = 1}})
end

local vpairs = {}
local vmap = {}
for i, col1 in ipairs(br_core.node_colors_list) do
    for k, col2 in ipairs(br_core.node_colors_list) do
        local name = col1.name .. "_" .. col2.name
        local name2 = col2.name .. "_" .. col1.name
        if (col1.name ~= col2.name) and (not vmap[name]) and (not vmap[name2]) then
            vmap[name] = true
            table.insert(vpairs, {col1.name, col2.name})
        end
    end
end
vmap = nil

local function default_on_place(itemstack, placer, pointed_thing)
    return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
end

for i, vpair in pairs(vpairs) do
    local variant = vpair[1] .. "_" .. vpair[2]
    local col1 = br_core.node_colors[vpair[1]]
    local col2 = br_core.node_colors[vpair[2]]
    local tile1, tile2

    tile1 = br_core.node_tile.concrete(col1, nil)
    tile2 = br_core.node_tile.concrete(col2, nil)
    core.register_node("br_core:concrete_"..variant, {
        description = "br_core:concrete_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        -- +Y, -Y, +X, -X, +Z, -Z
        tiles = {
            tile2, -- +Y
            tile1, -- -Y
            tile2, -- +X
            tile1, -- -X
            tile2, -- +Z
            tile1, -- -Z
        },
        paramtype2 = "facedir",
        sounds = br_sounds.concrete(),
        on_place = default_on_place,
    })
    register_craft({output = "br_core:concrete_"..variant, items = {unobtainable = 1}})

    tile1 = br_core.node_tile.concrete_dirty(col1, nil)
    tile2 = br_core.node_tile.concrete_dirty(col2, nil)
    core.register_node("br_core:concrete_dirty_"..variant, {
        description = "br_core:concrete_dirty_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        -- +Y, -Y, +X, -X, +Z, -Z
        tiles = {
            tile2, -- +Y
            tile1, -- -Y
            tile2, -- +X
            tile1, -- -X
            tile2, -- +Z
            tile1, -- -Z
        },
        paramtype2 = "facedir",
        sounds = br_sounds.concrete(),
        on_place = default_on_place,
    })
    register_craft({output = "br_core:concrete_dirty_"..variant, items = {unobtainable = 1}})

    tile1 = br_core.node_tile.concrete_ruined(col1, nil)
    tile2 = br_core.node_tile.concrete_ruined(col2, nil)
    core.register_node("br_core:concrete_ruined_"..variant, {
        description = "br_core:concrete_ruined_"..variant,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        -- +Y, -Y, +X, -X, +Z, -Z
        tiles = {
            tile2, -- +Y
            tile1, -- -Y
            tile2, -- +X
            tile1, -- -X
            tile2, -- +Z
            tile1, -- -Z
        },
        paramtype2 = "facedir",
        sounds = br_sounds.concrete(),
        on_place = default_on_place,
    })
    register_craft({output = "br_core:concrete_ruined_"..variant, items = {unobtainable = 1}})
end

core.register_alias("br_core:ceiling_tiles_0", "br_core:ceiling_tiles_yellow")

local framebox = br_core.get_full_frame({inner=true, width=6/16, thickness=1/16, nobottom=true})
core.register_node("br_core:doorframe_0", {
    description = "br_core:doorframe_0",
    pointable = br_core.nodes_pointable or false,
    groups = { suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_blank.png^[colorize:#99a:255^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    connects_to = { "group:full_solid" },
    node_box = framebox,
    sounds = br_sounds.default(),
})

core.register_node("br_core:duct_0", {
    description = "br_core:duct_0",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = { "br_".."duct_0.png" },
    sounds = br_sounds.concrete(),
}) register_shapes("br_core:duct_0")
register_craft({output = "br_core:duct_0", items = {unobtainable = 1}})


selectionbox = {
    type = "fixed",
    fixed = {
        {
            -8/16, -8/16,  8/16,
             8/16,  0/16,  0/16,
        },
    },
}
nodebox = {
    type = "fixed",
    fixed = {
        {
            -8/16, -8/16,  8/16,
             8/16, -4/16,  7/16,
        },
    },
}
-- skirting boards
core.register_node("br_core:skirting_0", {
    description = "br_core:skirting_0",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_blank.png^[colorize:#99a:255^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    sounds = br_sounds.default(),
    node_box = nodebox,
    selection_box = selectionbox,
    paramtype2 = "facedir",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
register_craft({output = "br_core:skirting_0", items = {unobtainable = 1}})

core.register_node("br_core:skirting_1", {
    description = "br_core:skirting_1",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_blank.png^[colorize:#556:255^(br_meta_overlay_dirt_1.png^[multiply:#753^[opacity:10)",
        align_style = "world",
        scale = 16,
    }},
    drawtype = "nodebox",
    sounds = br_sounds.default(),
    node_box = nodebox,
    selection_box = selectionbox,
    paramtype2 = "facedir",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {})
    end,
})
register_craft({output = "br_core:skirting_1", items = {unobtainable = 1}})



selectionbox = {
    type = "fixed",
    fixed = {
        {
            -8/16, -8/16,  -8/16,
             8/16, -4/16,  8/16,
        },
    },
}
-- ladders
core.register_node("br_core:ladder_steel_0", {
    description = "br_core:ladder_steel_0",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_ladder_steel_0.png",
    }},
    use_texture_alpha = "clip",
    drawtype = "signlike",
    sounds = br_sounds.default(),
    selection_box = selectionbox,
    climbable = true,
    paramtype2 = "wallmounted",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
})
register_craft({output = "br_core:ladder_steel_0", items = {unobtainable = 1}})

core.register_node("br_core:invis_light_14", {
    description = "br_core:invis_light_14",
    pointable = br_core.dev_mode or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, dig_immediate = (br_core.dev_mode and 3) or 0, },
    drawtype = (debug and "airlike") or "nodebox",
    tiles = { (br_core.dev_mode and 'br_barrier.png^[colorize:#ff0:255') or "blank.png" },
    use_texture_alpha = "clip",
    sounds = br_sounds.default(),
    paramtype = "light",
    light_source = 14,
    walkable = false,
})

core.register_node("br_core:invis_light_8", {
    description = "br_core:invis_light_8",
    pointable = br_core.dev_mode or false,
    groups = { solid = 0, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1, dig_immediate = (br_core.dev_mode and 3) or 0, },
    drawtype = (debug and "airlike") or "nodebox",
    tiles = { (br_core.dev_mode and 'br_barrier.png^[colorize:#aa0:255') or "blank.png" },
    use_texture_alpha = "clip",
    sounds = br_sounds.default(),
    paramtype = "light",
    light_source = 8,
    walkable = false,
})

local function world_align_textures(tiles)
    for i, t in pairs(tiles) do
        tiles[i] = {
            name = t,
            align_style = "world",
        }
    end
    return tiles
end
for i=0, 2 do
    core.register_node("br_core:pool_tiles_"..i, {
        description = "br_core:pool_tiles_"..i,
        pointable = br_core.nodes_pointable or false,
        groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
        tiles = world_align_textures({
            "br_tiles_"..i..".png", -- top
        }),
        sounds = br_sounds.tile(),
    }) register_shapes("br_core:pool_tiles_"..i)
    register_craft({output = "br_core:pool_tiles_"..i, items = {unobtainable = 1}})
end

core.register_node("br_core:grass", {
    description = "br_core:grass",
    pointable = br_core.nodes_pointable or false,
    groups = { solid = 1, full_solid = 1, suffocates = 2, oddly_breakable_by_hand = 2, cracky = 1 },
    tiles = {{
        name = "br_meta_grass.png^[multiply:#788e61"..
        "^(br_meta_overlay_flowers.png^[multiply:#f9d298^[opacity:100)",
        align_style = "world",
        scale = 16,
    }},
    sounds = br_sounds.carpet(),
}) register_shapes("br_core:grass")
register_craft({output = "br_core:grass", items = {unobtainable = 1}})
