local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

br_survival = {}

br_survival.__pl = {}

function br_survival.pi(player)
	local name = core.is_player(player) and player:get_player_name()
	if not name then return end
	local pi = br_survival.__pl[name]
	if not pi then pi = {}; br_survival.__pl[name] = pi end
	return pi
end

function br_survival.player_step(player, dtime, pi)
	br_survival.stats_step(player, dtime, pi)
end

core.register_globalstep(function(dtime)
	for i, player in ipairs(core.get_connected_players()) do
		local pi = br_survival.pi(player)
		br_survival.player_step(player, dtime, pi)
	end
end)

dofile(mod_path .. "/stats.lua")
