local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local function increment_id(itemstack, player, pointed_thing)
    if not core.is_player(player) then return end
    local meta = itemstack:get_meta()
    local id = tonumber(meta:get_string("keyid")) or (-1)
    local ctrl = player:get_player_control()
    if ctrl.aux1 then
        id = 0
    else
        id = (id + 1) % 16
    end
    meta:set_string("keyid", tostring(id))
    core.chat_send_player(player:get_player_name(), "key ID set to: " .. id)
    core.sound_play("br_key_rattle_0", {
        to_player = player:get_player_name(),
        gain = 0.3,
    })
    return itemstack
end

core.register_craftitem("br_core:key_tool", {
    description = S("Key Setting Tool"),
    _tt_how_to_use = S("[place] to change ID"),
    inventory_image = "br_key_tool.png",
    groups = { tool = 1, },
    stack_max = 1,
    on_secondary_use = function(itemstack, user, pointed_thing)
        if core.is_player(user) and not core.is_creative_enabled(user:get_player_name()) then
            return
        end
        return increment_id(itemstack, user, pointed_thing)
    end,
    on_use = function (itemstack, player, pointed_thing)
        if core.is_player(player) and not core.is_creative_enabled(player:get_player_name()) then
            return
        end
        if not pointed_thing then return end
        if not pointed_thing.under then return end
        local node = core.get_node(pointed_thing.under)
        if core.get_item_group(node.name, "door") <= 0 then return end
        local info = br_core.door.explode_param2(node.param2)
        core.chat_send_player(player:get_player_name(), dump(info))
        core.sound_play("br_key_rattle_0", {
            to_player = player:get_player_name(),
            gain = 0.3,
        })
    end,
    on_place = function(itemstack, user, pointed_thing)
        if core.is_player(user) and not core.is_creative_enabled(user:get_player_name()) then
            return
        end
        if not core.is_player(user) then return end
        local node = core.get_node(pointed_thing.under)
        if core.get_item_group(node.name, "door") > 0 then
            local info = br_core.door.explode_param2(node.param2)
            local meta = itemstack:get_meta()
            local id = tonumber(meta:get_string("keyid")) or core.get_item_group(itemstack:get_name(), "key")
            info.lock_id = id
            local n = br_core.door.combine_param2(info)
            node.param2 = n
            core.swap_node(pointed_thing.under, node)
            br_core.door.update_infotext(pointed_thing.under, info, nil)
            core.chat_send_player(user:get_player_name(), S("Key ID set to: @1", id))
            core.sound_play("br_key_rattle_0", {
                to_player = user:get_player_name(),
                gain = 0.3,
            })
        else
            return increment_id(itemstack, user, pointed_thing)
        end
    end,
})

core.register_craftitem("br_core:key_2", {
    description = S("Storage Key"),
    inventory_image = "br_key_2.png",
    groups = { tool = 1, key = 2, single_use = 0, keep_unlocked = 1, },
    stack_max = 1,
    -- _on_unlock = function(itemstack, user, pointed_thing)
    -- end,
    -- _on_unlock_fail = function(itemstack, user, pointed_thing)
    -- end,
})

core.register_craftitem("br_core:key_3", {
    description = S("Maintenance Key"),
    inventory_image = "br_key_3.png",
    groups = { tool = 1, key = 3, single_use = 0, keep_unlocked = 1, },
    stack_max = 1,
})

core.register_craftitem("br_core:key_4", {
    description = S("House Key"),
    inventory_image = "br_key_4.png",
    groups = { tool = 1, key = 4, single_use = 0, keep_unlocked = 1, },
    stack_max = 1,
})
