local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local function use_relocator(itemstack, user, pointed_thing)
    local ct = player_info and player_info.get(user)
    if ct and not ct.ctrl.sneak then
        if not minetest.is_creative_enabled(user:get_player_name()) then
            br_spawn.relocate_player(user, br_spawn.player[user:get_player_name()].level)
            return itemstack
        end
        local level_index = math.random(#br_core.level_for_index)
        local pli = br_spawn.player[user:get_player_name()]
        if br_core.level_for_index[level_index] == pli.level then level_index = (level_index) % #br_core.level_for_index + 1 end
        level_index = br_core.level_for_index[level_index]
        br_spawn.relocate_player(user, level_index)
        return itemstack
    end
end

minetest.register_tool("br_core:relocator", {
    description = S("Use When Stuck"),
    _on_inventory_move_allow = function() return 0 end,
	_on_drop = function(itemstack, player) return false end,
    inventory_image = "br_use_when_stuck.png",
    wield_image = "blank.png",
    groups = { relocator = 1 },
    on_secondary_use = use_relocator,
    on_place = use_relocator,
})
