local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- drains
br_core.register_level({
    level = 17,
    desc = "Level 17",
    danger = 2,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 6,
    biome_roughness = 17862,
    biome_pixelization = 4,
    survival_stats = false,
    sun = {
        visible = true,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

br_core.register_biome({
    level = 17,
    desc = "Level 17 canals",
    danger = 2,
    on_generate = nil,
    segheight = 20,
    can_generate = function(pos)
        return true
    end,
    schems = {
        {name=sch("17_fill_0"), rotation=0, vertical_segments={0,1,1,1}},
        {name=sch("17_canal_0"), rotation=0, prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_canal_1"), rotation=0, prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_canal_1"), rotation=2, prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_canal_2"), rotation=0, prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_canal_2"), rotation=2, prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_canal_2_portal"), rotation=2, prevalence=1, vertical_segments={1,0,0,0}},
        -- {name=sch("17_canal_0"), rotation=2, prevalence=1, vertical_segments={1,0,0}},
    }
})
br_core.register_biome({
    level = 17,
    desc = "Level 17 storm drains",
    danger = 0,
    on_generate = nil,
    segheight = 20,
    can_generate = function(pos)
        return true
    end,
    schems = {
        {name=sch("17_fill_0"), rotation=0, vertical_segments={0,1,1,1}},
        {name=sch("17_storm_drains_0"), rotation=0, prevalence=1, vertical_segments={1,0,0,0}, skip_above=3},
    }
})

local noise_pools = PerlinNoise({
    offset = 0.5,
    scale = 0.5,
    spread = {x = 60, y = 60, z = 60},
    seed = 654643 + core.get_mapgen_setting("seed"),
    octaves = 3,
    persist = 0.2,
    lacunarity = 2.0,
})
br_core.register_biome({
    level = 17,
    desc = "Level 17 pools",
    danger = 0,
    on_generate = nil,
    segheight = 20,
    can_generate = function(pos)
        return noise_pools:get_3d(pos) > 0.2
    end,
    schems = {
        {name=sch("17_fill_0"), rotation=0, vertical_segments={0,1,1,1}},
        {name=sch("17_pools_0"), prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_pools_1"), prevalence=3, vertical_segments={1,0,0,0}},
        {name=sch("17_pools_2"), prevalence=3, vertical_segments={1,0,0,0}},
    }
})

br_core.register_level_sound({
    level = 17,
    time = 40,
    on_play = function(self, dtime, player)
        local can_play = false
        local playing = br_core.sound_get_tag("17_dripsandwater", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("17_dripsandwater", player, {
                name = "br_dripsandwater_WTFPL_Sumianvoice",
                level = 17,
                gain = (br_sounds.master or 1) * math.random() * 0.5,
                fade = 0.2,
                -- single_sound = true,
                max_hear_distance = 50,
                to_player = player:get_player_name(),
                -- pos = get_centre_of_segment(player:get_pos()),
                time = 40,
            })
        end
    end
})
