local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

local level = 31

-- gaps
br_core.register_level({
    level = level,
    desc = "Level 31",
    danger = 0,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 42,
    biome_roughness = 91.798,
    sun = {
        visible = false,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})
br_core.register_biome({
    level = level,
    desc = "Level 31",
    danger = 0,
    on_generate = nil,
    segheight = 10,
    prevalence=2,
    can_generate = function(pos) -- must be deterministic
        return ((pos.z%5 ~= 0) or (pos.x%3 == 0))
    end,
    schems = {
        {name=sch("31_10h_corridor_base"),  vertical_segments={1}, prevalence=3, rotation=0},
        {name=sch("31_10h_corridor_roof"),  vertical_segments={0,0,0,0,0,0,0,1}, rotation=0, prevalence=7},
        {name=sch("31_10h_corridor_0"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0, prevalence=7},
        {name=sch("31_10h_corridor_1"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0, prevalence=7},
        {name=sch("31_10h_corridor_2"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0, prevalence=7},
        {name=sch("31_10h_corridor_3"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0, prevalence=7},
        {name=sch("31_10h_corridor_4"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0, prevalence=7},
        {name=sch("31_10h_corridor_5"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0, prevalence=7},
        {name=sch("31_20h_stairs_0"), vertical_segments={0,1,1,1,1,1,0,0}, skip_above=1, prevalence=3},
        {name=sch("31_20h_stairs_1"), vertical_segments={0,1,1,1,1,1,0,0}, skip_above=1, prevalence=3},
        {name=sch("31_20h_stairs_0_portal"), vertical_segments={0,1,1,1,1,1,0,0}, skip_above=1, prevalence=3},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 31",
    danger = 0,
    on_generate = nil,
    segheight = 10,
    can_generate = function(pos) -- must be deterministic
        return (pos.z%5 ~= 0 and (pos.x%8 < 4 and pos.z%7 < 4))
    end,
    schems = {
        {name=sch("31_10h_balcony_base"),  vertical_segments={1}, prevalence=3},
        {name=sch("31_10h_balcony_roof"),  vertical_segments={0,0,0,0,0,0,0,1}},

        {name=sch("31_10h_balcony_0"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        {name=sch("31_10h_balcony_1"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        {name=sch("31_10h_balcony_2"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        {name=sch("31_10h_balcony_3"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        {name=sch("31_10h_balcony_4"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        {name=sch("31_10h_balcony_5"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        {name=sch("31_10h_balcony_6"),     vertical_segments={0,1,1,1,1,1,1,0}, prevalence=3},
        --
        {name=sch("31_10h_balcony_0_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
        {name=sch("31_10h_balcony_1_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
        {name=sch("31_10h_balcony_2_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
        {name=sch("31_10h_balcony_3_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
        {name=sch("31_10h_balcony_4_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
        {name=sch("31_10h_balcony_5_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
        {name=sch("31_10h_balcony_6_portal"),     vertical_segments={0,1,1,1,1,1,1,0}},
    }
})

br_core.register_biome({
    level = level,
    desc = "Level 31 SHORT",
    danger = 0,
    on_generate = nil,
    segheight = 10,
    prevalence = 1,
    can_generate = function(pos) -- must be deterministic
        return pos.z%5 == 0
    end,
    schems = {
        {name=sch("31_10h_corridor_short_base"),  vertical_segments={1}, prevalence=3, rotation=0},
        {name=sch("31_10h_corridor_short_roof"),  vertical_segments={0,0,0,0,0,0,0,1}, rotation=0},
        {name=sch("31_10h_corridor_short_0"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0},
        {name=sch("31_10h_corridor_short_1"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0},
        {name=sch("31_10h_corridor_short_2"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0},
        {name=sch("31_10h_corridor_short_3"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0},
        {name=sch("31_10h_corridor_short_4"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0},
        {name=sch("31_10h_corridor_short_5"),     vertical_segments={0,1,1,1,1,1,1,0}, rotation=0},
    }
})

br_core.register_level_sound({
    level = level,
    time = 10,
    on_play = function(self, dtime, player)
        local can_play = false
        local playing = br_core.sound_get_tag("level31_hum", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level31_hum", player, {
                name = "br_traffic_distant_cc0_klangfabrik",
                level = level,
                gain = (br_sounds.master or 1) * (0.5 * math.random() + 0.3),
                fade = 0.3,
                -- single_sound = true,
                max_hear_distance = 50,
                to_player = player:get_player_name(),
                time = 10,
            })
        end
    end
})

-- junk and occasional supplies
br_core.set_loot_table(level, 0, {
    node_names = {"br_core:loot_crate"},
    max_items = 4,
    items = {
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.food(32),
        br_core.loot.list.food(32),
        br_core.loot.list.drinks(32),
        br_core.loot.list.drinks(32),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- food
br_core.set_loot_table(level, 1, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
    },
})
-- drinks
br_core.set_loot_table(level, 2, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.drinks(8),
        br_core.loot.list.drinks(8),
        br_core.loot.list.drinks(8),
    },
})
-- tools and supplies
br_core.set_loot_table(level, 3, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.tools(3),
        br_core.loot.list.junk(3),
        br_core.loot.list.junk(3),
        {items = {"br_core:key_2 1"}, rarity = 22},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- jackpot
br_core.set_loot_table(level, 4, {
    node_names = {"br_core:loot_crate"},
    max_items = 16,
    items = {
        br_core.loot.list.food(6),
        br_core.loot.list.food(6),
        br_core.loot.list.drinks(6),
        br_core.loot.list.drinks(6),
        br_core.loot.list.tools(4),
        {items = {"br_core:key_2 1"}, rarity = 8},
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
    },
})
-- keys
br_core.set_loot_table(level, 8, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        {items = {"br_core:key_2 1"}, rarity = 8},
        br_core.loot.list.junk(8),
        br_core.loot.list.junk(8),
        br_core.loot.list.tools(8),
    },
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_0",
    node_name = "br_core:loot_crate_0",
    rarity = 34,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_1",
    node_name = "br_core:loot_crate_1",
    rarity = 34,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_2",
    node_name = "br_core:loot_crate_2",
    rarity = 34,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_3",
    node_name = "br_core:loot_crate_3",
    rarity = 34,
})
