local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

local level = 37

-- poolrooms
br_core.register_level({
    level = level,
    desc = "Level 37",
    danger = 0,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 20,
    biome_roughness = 896,
    biome_pixelization = 4,
    sun = {
        visible = true,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#def",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})

br_core.register_biome({
    level = level,
    desc = "Level 37 columns",
    danger = 0,
    on_generate = nil,
    can_generate = function(pos) -- must be deterministic
        if vector.distance(pos, vector.new(0, pos.y, 0)) > 10 then
            return false
        else
            return true
        end
    end,
    schems = {
        {name=sch("37_channel_0")},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 main",
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("37_channel_0"), rotation=0, prevalence=3+2},
        {name=sch("37_channel_1"), rotation=0, prevalence=3+2},
        {name=sch("37_channel_2"), rotation=0, prevalence=2+2},
        {name=sch("37_channel_3"), rotation=0, prevalence=1+2},
        {name=sch("37_channel_4"), rotation=0, prevalence=2+2},
        {name=sch("37_channel_0"), prevalence=3},
        {name=sch("37_channel_1"), prevalence=3},
        {name=sch("37_channel_2"), prevalence=2},
        {name=sch("37_channel_3"), prevalence=1},
        {name=sch("37_channel_4"), prevalence=2},
        {name=sch("37_pool_0"), prevalence=2},
        {name=sch("37_stair_0"), prevalence=2},
    }
})
br_core.register_biome({
    level = level,
    desc = "Level 0 closed",
    danger = 0,
    on_generate = nil,
    prevalence = 1,
    schems = {
        {name=sch("37_channel_0"), rotation=0, prevalence=1},
        {name=sch("37_channel_2"), rotation=0, prevalence=1},
        {name=sch("37_closed_0"), prevalence=5},
        {name=sch("37_closed_1"), prevalence=4},
        {name=sch("37_closed_1_portal"), prevalence=1},
        {name=sch("37_pool_0"), prevalence=2},
        {name=sch("37_stair_0"), prevalence=2},
    }
})

br_core.register_level_sound({
    level = level,
    time = 40,
    on_play = function(self, dtime, player)
        local can_play = false
        local playing = br_core.sound_get_tag("37_dripsandwater", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("37_dripsandwater", player, {
                name = "br_dripsandwater_WTFPL_Sumianvoice",
                level = level,
                gain = (br_sounds.master or 1) * math.random(),
                fade = 0.2,
                -- single_sound = true,
                max_hear_distance = 50,
                to_player = player:get_player_name(),
                -- pos = get_centre_of_segment(player:get_pos()),
                time = 40,
            })
        end
    end
})

-- junk and occasional supplies
br_core.set_loot_table(level, 0, {
    node_names = {"br_core:loot_crate"},
    max_items = 4,
    items = {
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.food(56),
        br_core.loot.list.food(56),
        br_core.loot.list.drinks(32),
        br_core.loot.list.drinks(32),
        {items = {"br_core:key_2 1"}, rarity = 44},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- food
br_core.set_loot_table(level, 1, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
        br_core.loot.list.food(23),
    },
})
-- drinks
br_core.set_loot_table(level, 2, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.drinks(16),
        br_core.loot.list.drinks(16),
        br_core.loot.list.drinks(16),
    },
})
-- tools and supplies
br_core.set_loot_table(level, 3, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        br_core.loot.list.tools(3),
        br_core.loot.list.junk(3),
        br_core.loot.list.junk(3),
        {items = {"br_core:key_2 1"}, rarity = 44},
        {items = {"br_core:key_3 1"}, rarity = 22},
    },
})
-- jackpot
br_core.set_loot_table(level, 4, {
    node_names = {"br_core:loot_crate"},
    max_items = 16,
    items = {
        br_core.loot.list.food(6),
        br_core.loot.list.food(6),
        br_core.loot.list.drinks(6),
        br_core.loot.list.drinks(6),
        br_core.loot.list.tools(4),
        {items = {"br_core:key_2 1"}, rarity = 8},
        {items = {"br_core:key_3 1"}, rarity = 14},
        {items = {"br_core:key_4 1"}, rarity = 14},
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
        br_core.loot.list.junk(5),
    },
})
-- keys
br_core.set_loot_table(level, 8, {
    node_names = {"br_core:loot_crate"},
    max_items = 8,
    items = {
        {items = {"br_core:key_2 1"}, rarity = 8},
        {items = {"br_core:key_3 1"}, rarity = 14},
        {items = {"br_core:key_4 1"}, rarity = 14},
        br_core.loot.list.junk(8),
        br_core.loot.list.junk(8),
        br_core.loot.list.tools(8),
    },
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_0",
    node_name = "br_core:loot_crate_0",
    rarity = 70,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_1",
    node_name = "br_core:loot_crate_1",
    rarity = 66,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_2",
    node_name = "br_core:loot_crate_2",
    rarity = 54,
})

br_core.add_loot_ore(level, {
    wherein = "br_core:loot_area_3",
    node_name = "br_core:loot_crate_3",
    rarity = 54,
})
