local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- 51
br_core.register_level({
    level = 51,
    desc = "Level 51 area",
    danger = 1,
    grace_dist = 5,
    biome = {},
    segsize = 20,
    base_height = 2,
    biome_roughness = 8.654,
    survival_stats = false,
    sun = {
        visible = false,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#001",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})
br_core.register_biome({
    level = 51,
    desc = "Level 51",
    danger = 1,
    on_generate = nil,
    segheight = 10,
    can_generate = function(pos) -- must be deterministic
        return true
    end,
    schems = {
        {name=sch("51_shelves_0"),  vertical_segments={1}, prevalence=1, skip_above=3},
        {name=sch("51_shelves_1"),  vertical_segments={1}, prevalence=1, skip_above=3},
        {name=sch("51_shelves_0_portal"),  vertical_segments={1}, prevalence=1, skip_above=3, can_generate = function(pos)
            return ((pos.x % 2 == 0) and (pos.z % 2 == 0))
        end},
        {name=sch("51_shelves_0"),  vertical_segments={1}, prevalence=3, skip_above=3, rotation=0},
        {name=sch("51_shelves_1"),  vertical_segments={1}, prevalence=3, skip_above=3, rotation=0},
    }
})
br_core.register_biome({
    level = 51,
    desc = "Level 51",
    danger = 1,
    on_generate = nil,
    segheight = 10,
    schems = {
        {name=sch("51_shelves_0"),  vertical_segments={1}, prevalence=1, skip_above=3},
        {name=sch("51_shelves_1"),  vertical_segments={1}, prevalence=1, skip_above=3},
        {name=sch("51_piles_0"),  vertical_segments={1}, prevalence=9, skip_above=3},
        {name=sch("51_piles_0_portal"),  vertical_segments={1}, prevalence=1, skip_above=3},
        {name=sch("51_car_0"),  vertical_segments={1}, prevalence=1, skip_above=3, can_generate = function(pos)
            return ((pos.x % 3 == 0) and (pos.z % 2 == 0))
        end},
    }
})
