local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local function sch(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end

-- hospital
br_core.register_level({
    level = 62,
    desc = "Level 62 hospital",
    danger = 2,
    grace_dist = 5,
    biome = {},
    segsize = 40,
    base_height = 2,
    survival_stats = false,
    sun = {
        visible = false,
        texture = "blank.png",
        sunrise_visible = false,
    },
    moon = {
        visible = false,
    },
    sky = {
        clouds = false,
        base_color = "#eee",
        type = "plain",
        fog = {
            fog_start = -1,
            fog_distance = -1,
        },
    },
})
br_core.register_biome({
    level = 62,
    desc = "Level 62",
    danger = 2,
    on_generate = nil,
    schems = {
        {name=sch("62_corridors_0"), rotation=0},
        {name=sch("62_corridors_0"), rotation=1},
        {name=sch("62_corridors_1"), rotation=0},
        {name=sch("62_corridors_1"), rotation=1},
        {name=sch("62_corridors_2"), rotation=0},
        {name=sch("62_corridors_2"), rotation=1},
        {name=sch("62_corridors_closed_0"), rotation=0, prevalence=3},
        {name=sch("62_corridors_closed_0"), rotation=1, prevalence=3},
    }
})

br_core.register_level_sound({
    level = 62,
    time = 8,
    on_play = function(self, dtime, player)
        local can_play = false
        local playing = br_core.sound_get_tag("level62_hum", player)
        if playing == nil or #playing < 1
        or (playing and playing[1].fading and #playing <= 1) then can_play = true end
        if can_play then
            br_core.sound_play("level62_hum", player, {
                name = "br_fluorescent_hum",
                level = 62,
                gain = (br_sounds.master or 1) * (0.04 * math.random() + 0.001),
                fade = 0.01,
                to_player = player:get_player_name(),
                time = 8,
            })
        end
    end
})
