local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

_G.no_inside_node = {}

-- list of offsets to check, with the Y positions being last
local adjacent = {
    vector.new(1, 0, 0),
    vector.new(-1, 0, 0),
    vector.new(0, 0, 1),
    vector.new(0, 0, -1),
    vector.new(0, 1, 0),
    vector.new(0, -1, 0),
}

-- true if there is a node between these positions with selectionbox in the way
local function is_in_node_by_raycast(pos1, pos2)
    local ray = minetest.raycast(pos1, pos2, false, false)
    for pointed_thing in ray do
        local ndef = minetest.registered_nodes[minetest.get_node(pointed_thing.under).name]
        if ndef and ndef.walkable then return true end
    end
    return false
end

-- looks adjacent to determine "how to get out" of this location
local function find_adj(pos, only_horiz)
    local ret = vector.new(0,0,0)
    local found = false
    for i, offset in ipairs(adjacent) do repeat
        if only_horiz and i >= 5 then break end

        local p = pos + offset
        local ndef = minetest.registered_nodes[minetest.get_node(p).name]
        if ndef and not ndef.walkable then
            if not found then
                ret = ret + offset * 2
                found = true
            else
                ret = ret + offset
            end
        else
            ret = ret - offset
        end
    until true end

    return ret
end

-- does logic on the player to find if they are in a node and then pushes them out
function no_inside_node.check_player(player, dtime)
    local pos = player:get_pos()
    local props = player:get_properties()
    local startp = vector.new(pos.x, pos.y + props.collisionbox[2] + 0.01, pos.z)
    local endp = vector.new(pos.x, pos.y + props.collisionbox[5] - 0.01, pos.z)

    local dir = vector.new(0,0,0)

    if not is_in_node_by_raycast(startp, endp) then return end

    for i = startp.y, endp.y, 1 do
        local p = vector.new(pos.x, i, pos.z)
        dir = dir + find_adj(p, (
            (i > startp.y) and (i < endp.y-1)
        ))
    end

    dir = vector.normalize(dir)
    local diff = vector.length(player:get_velocity() - dir)
    if diff < 4 then
        dir = dir * 4
    end
    player:add_velocity(dir)
end

-- use a timer to reduce overhead and make add_velocity more predictible
local t = 0
minetest.register_globalstep(function(dtime)
    t = t + dtime
    if t < 0.1 then return end
    t = t - 0.1
    for i, player in ipairs(minetest.get_connected_players()) do
        no_inside_node.check_player(player, dtime)
    end
end)
