

local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_mirecaves.max
local alt_min = pmb_mirecaves.min


local segment_count = 3
local segment_height = (pmb_mirecaves.max - pmb_mirecaves.min) / segment_count



local size = 70
local np = {
    offset = -segment_height,
    scale = 13,
    spread = {x = size, y = size, z = size},
    seed = 436,
    octaves = 5,
}
local npt_size = 300
local npt = {
    offset = -100,
    scale = 150,
    spread = {x = npt_size, y = npt_size, z = npt_size*3},
    seed = 768,
    octaves = 6,
    persistence = 0.2
}

local n = pmb_mirecaves.worknodes

for i=0, segment_count do
    --------------------------------
    -- MAKE THE MAIN BULK
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.topsoil,
        wherein        = {"group:solid", "group:liquid"},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)),
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    --------------------------------
    -- SOIL
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.temp_node,
        wherein        = {n.topsoil},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) + 6,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    --------------------------------
    -- GRASS
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.topsoil2,
        wherein        = {n.topsoil},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) + 5,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    --------------------------------
    -- ceiling
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.ceiling,
        wherein        = {n.temp_node},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) - 0,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.temp_node,
        wherein        = {n.ceiling},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) - 3,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "pmb_mirecaves:stone",
        wherein        = {"group:stone"},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) - 10,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    --------------------------------
    -- glow in valleys
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "pmb_mirecaves:stone_moss",
        wherein        = {n.topsoil2},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) + 30,
            scale     = np.scale - 50,
            spread   = vector.multiply(np.spread, 0.5),
            seed       = np.seed + i * 15,
            octaves = 5
        },
        np_stratum_thickness = {
            offset   = npt.offset - 30,
            scale     = npt.scale + 30,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = 7,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
    --------------------------------
    -- water
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        -- ore            = "pmb_mirecaves:nolmer", --"pmb_nodes_surface:water_source",
        ore            = "pmb_mirecaves:river_cave_water_source",
        wherein        = {n.temp_node, n.topsoil2},
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + pmb_mirecaves.min + (i * (segment_height)) - 50,
            scale     = 0,
            spread   = vector.multiply(np.spread, 0.5),
            seed       = np.seed + i * 15,
            octaves = 5
        },
        np_stratum_thickness = {
            offset   = 40,
            scale     = 0,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = 7,
            persistence = npt.persistence,
        },
        biomes = pmb_mirecaves.biome_list,
    })
end








