local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local plant_box = {
    type = "fixed",
    fixed = {
        {
            8/16, 0/16, 8/16, -8/16, -8/16, -8/16,
        },
    }
}

local chance_to_grow_pumpkin = 0.3
local chance_to_expand = 1
local chance_for_bonus_expand = 0.5
local grow_time = {x=12, y=20}
local pumpkin_time = 400
local die_time = 1200
local die_time_rand = 20
local chance_to_die = 0.2

--[[
    on update; set timer
    on timer complete, grow into plant and start that timer
    on timer complete, have chance:
        grow pumpkin
        expand
        die
]]

local adjacent = {
    vector.new(0, 0, 1),
    vector.new(0, 0,-1),
    vector.new(1, 0, 0),
    vector.new(-1,0, 0),
}

local function get_adjacent_count(pos, group)
    local count = 0
    for i, p in pairs(adjacent) do
        local node = minetest.get_node(vector.add(pos, p))
        if minetest.get_item_group(node.name, group) > 0 then
            count = count + 1
        end
    end
    return count
end

minetest.register_node("pmb_flora:pumpkin_plant", {
    description = pmb_util.desc(S("Pumpkin"), "grey"),
    _tt_long_desc = S("Pumpkin leaves"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin_plant = 1 },
    drawtype = "nodebox",
    node_box = plant_box,
    sunlight_propagates = true,
    walkable = false,
    paramtype = "light",
    drop = "",
    tiles = {
        "pmb_pumpkin_plant.png",
    },
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
    on_timer = function(pos, elapsed)
        local meta = minetest.get_meta(pos)
        local meta_pos = meta:get("grew_from_pos")
        local grew_from_pos = (meta_pos and vector.from_string(meta_pos)) or pos

        local near = get_adjacent_count(pos, "pumpkin_plant")

        local found = false
        for i=math.random(#adjacent), #adjacent do
            local p = adjacent[i % (#adjacent + 1)]
            local pp = vector.add(p, pos)
            local n = minetest.get_node(pp)
            local below = vector.offset(pp, 0, -1, 0)
            if minetest.get_item_group(minetest.get_node(below).name, "soil") > 0
            and ((not found) or math.random() < chance_for_bonus_expand or vector.distance(grew_from_pos, pos) <= 2)
            and minetest.registered_nodes[n.name].buildable_to then
                if math.random() < chance_to_expand and vector.distance(grew_from_pos, pos) < 5 then
                    minetest.dig_node(pp)
                    if math.random() < chance_to_grow_pumpkin and vector.distance(grew_from_pos, pos) > 1 then
                        minetest.set_node(pp, {name="pmb_flora:pumpkin_1"})
                        minetest.get_node_timer(pp):start(math.random() * (grow_time.y - grow_time.x) + pumpkin_time)
                        found = true
                    else
                        minetest.set_node(pp, {name="pmb_flora:pumpkin_plant"})
                        minetest.get_node_timer(pp):start(math.random() * (grow_time.y - grow_time.x) + grow_time.x)
                        local ppmeta = minetest.get_meta(pp)
                        ppmeta:set_string("grew_from_pos", vector.to_string(grew_from_pos))
                    end
                end

                if math.random() < chance_to_die then
                    break
                end
            end
        end
        minetest.set_node(pos, {name="pmb_flora:pumpkin_plant_inactive"})
        minetest.get_node_timer(pos):start(math.random() * die_time_rand + die_time)
    end,
    _on_node_update = function(pos, cause, user, count, payload)
        local timer = minetest.get_node_timer(pos)
        if timer:is_started() then
            return false
        else
            timer:start(math.random() * (grow_time.y - grow_time.x) + grow_time.x)
            return false
        end
    end,
})

minetest.register_node("pmb_flora:pumpkin_plant_inactive", {
    description = pmb_util.desc(S("Pumpkin"), "grey"),
    _tt_long_desc = S("Pumpkin leaves"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin = 1 },
    drawtype = "nodebox",
    node_box = plant_box,
    -- buildable_to = true,
    walkable = false,
    sunlight_propagates = true,
    paramtype = "light",
    drop = "",
    tiles = {
        "pmb_pumpkin_plant.png",
    },
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
    on_timer = function(pos, elapsed)
        minetest.set_node(pos, {name="pmb_flora:pumpkin_plant_dead"})
    end,
})

minetest.register_node("pmb_flora:pumpkin_plant_dead", {
    description = pmb_util.desc(S("Pumpkin"), "grey"),
    _tt_long_desc = S("Pumpkin leaves"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin = 1 },
    drawtype = "signlike",
    node_box = plant_box,
    selection_box = plant_box,
    buildable_to = true,
    walkable = false,
    sunlight_propagates = true,
    paramtype = "light",
    drop = "",
    tiles = {
        "pmb_pumpkin_plant_dead.png",
    },
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
    _on_node_update = function(pos, cause, user, count, payload)
        minetest.set_node(pos, {name="air"})
        return true
    end,
})

minetest.register_node("pmb_flora:pumpkin", {
    description = pmb_util.desc(S("Pumpkin"), "grey"),
    _tt_long_desc = S("Pumpkin"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin = 1 },
    tiles = {
        "pmb_pumpkin_top.png",
        "pmb_pumpkin_bottom.png",
        "pmb_pumpkin_side.png",
    },
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
})




local pumpkin_box_1 = {
    type = "fixed",
    fixed = {{ 4/16, 0/16, 4/16, -4/16, -8/16, -4/16 }}
}
local pumpkin_box_2 = {
    type = "fixed",
    fixed = {{ 6/16, 4/16, 6/16, -6/16, -8/16, -6/16 }}
}

minetest.register_node("pmb_flora:pumpkin_1", {
    description = pmb_util.desc(S("Pumpkin"), "grey"),
    _tt_long_desc = S("Pumpkin"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin = 1 },
    drawtype = "nodebox",
    node_box = pumpkin_box_1,
    drop = "pmb_flora:pumpkin_seeds",
    tiles = {
        "pmb_pumpkin_1_top.png",
        "pmb_pumpkin_1_bottom.png",
        "pmb_pumpkin_1_side.png",
    },
    sunlight_propagates = true,
    paramtype = "light",
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
    on_timer = function(pos, elapsed)
        minetest.set_node(pos, {name="pmb_flora:pumpkin_2"})
        minetest.get_node_timer(pos):start(math.random() * (grow_time.y - grow_time.x) + grow_time.x)
    end,
    _on_node_update = function(pos, cause, user, count, payload)
        local timer = minetest.get_node_timer(pos)
        if timer:is_started() then
            return false
        else
            timer:start(math.random() * (grow_time.y - grow_time.x) + grow_time.x)
            return false
        end
    end,
})
minetest.register_node("pmb_flora:pumpkin_2", {
    description = pmb_util.desc(S("Pumpkin"), "grey"),
    _tt_long_desc = S("Pumpkin"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin = 1 },
    drawtype = "nodebox",
    node_box = pumpkin_box_2,
    drop = "pmb_flora:pumpkin_seeds",
    tiles = {
        "pmb_pumpkin_1_top.png",
        "pmb_pumpkin_1_bottom.png",
        "pmb_pumpkin_1_side.png",
    },
    sunlight_propagates = true,
    paramtype = "light",
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
    on_timer = function(pos, elapsed)
        minetest.set_node(pos, {name="pmb_flora:pumpkin"})
        minetest.get_node_timer(pos):start(math.random() * (grow_time.y - grow_time.x) + grow_time.x)
    end,
    _on_node_update = function(pos, cause, user, count, payload)
        local timer = minetest.get_node_timer(pos)
        if timer:is_started() then
            return false
        else
            timer:start(math.random() * (grow_time.y - grow_time.x) + pumpkin_time)
            return false
        end
    end,
})



minetest.register_node("pmb_flora:pumpkin_seeds", {
    description = pmb_util.desc(S("Pumpkin Seed"), "grey"),
    _tt_long_desc = S("Pumpkin seeds for planting"),
    groups = { item_pumpkin = 1, dig_immediate = 3, solid = 1, pumpkin = 1 },
    drawtype = "signlike",
    node_box = plant_box,
    buildable_to = false,
    walkable = false,
    sunlight_propagates = true,
    paramtype = "light",
    drop = "pmb_flora:pumpkin_seeds",
    tiles = {
        "pmb_pumpkin_plant.png",
    },
    inventory_image = "pmb_pumpkin_seed.png",
    wield_image = "pmb_pumpkin_seed.png",
    backface_culling = true,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),
    on_timer = function(pos, elapsed)
        minetest.set_node(pos, {name="pmb_flora:pumpkin_plant"})
        minetest.get_node_timer(pos):start(math.random() * (grow_time.y - grow_time.x) + grow_time.x)
    end,
    _on_node_update = function(pos, cause, user, count, payload)
        local timer = minetest.get_node_timer(pos)
        if timer:is_started() then
            return false
        else
            timer:start(math.random() * (grow_time.y - grow_time.x) + pumpkin_time)
            return false
        end
    end,
})
minetest.register_craft({
    output = "pmb_flora:pumpkin_seeds 2",
    type = "shapeless",
    recipe = {
        "pmb_flora:pumpkin"
    },
})


