

local me = pmb_mob_spawn

function me.mob_spawn_step(dtime)
    -- for each player, find places near them to spawn stuff
end

function me.is_cap_exceded(mob_name)
    for _, groupname in pairs(pmb_mob_spawn.mob[mob_name].groups) do
        if pmb_mob_spawn.cap[groupname].cur > pmb_mob_spawn.cap[groupname].max then
            return true
        end
    end
    return false
end

-- pick a mob based on the location
function me.get_spawn_mob(pos, choosefrom)
    if not me.has_player_in_range(pos, me.spawn_dist.min, me.spawn_dist.max) then return false end
    local test_in = choosefrom or pmb_mob_spawn.mob_index

    local biome_data = minetest.get_biome_data(pos)
    local spawn_info = {
        biome_name = minetest.get_biome_name(biome_data.biome),
        biome_data = biome_data,
    }

    for try=0, 4 do
        local i = math.random(1, #test_in)
        local mob_name = test_in[i]
        local mob_reg = pmb_mob_spawn.mob[mob_name]
        if not mob_reg then goto continue end
        if (mob_reg.biomes and #mob_reg.biomes > 0
        and mob_reg.biomes[spawn_info.biome_name] == nil) then
            -- minetest.chat_send_all("could not spawn " .. tostring(mob_name) .. ", biome " .. tostring(spawn_info.biome_name) .. " not allowed.")
            return end

        if me.is_cap_exceded(mob_name) then goto continue end

        if mob_reg.can_spawn and not mob_reg.can_spawn(pos, spawn_info) then
            goto continue
        end

        if true then
            return mob_name
        end

        ::continue::
    end
    return false
end

function me.add_to_cap(mob_name)
    if not pmb_mob_spawn.mob[mob_name] then
        -- minetest.log(mob_name)
        return false
    end
    for _, groupname in pairs(pmb_mob_spawn.mob[mob_name].groups) do
        pmb_mob_spawn.cap[groupname].cur = pmb_mob_spawn.cap[groupname].cur + 1
    end
end
function me.take_from_cap(mob_name)
    if not pmb_mob_spawn.mob[mob_name] then
        -- minetest.log(mob_name)
        return false
    end
    for _, groupname in pairs(pmb_mob_spawn.mob[mob_name].groups) do
        pmb_mob_spawn.cap[groupname].cur = pmb_mob_spawn.cap[groupname].cur - 1
    end
end
function me.reset_cap()
    for groupname, group in pairs(pmb_mob_spawn.cap) do
        if not group.cur or group.cur == 0 then
        else
            group.cur = 0
        end
    end
end
function me.recalculate_cap()
    me.reset_cap()
    for _, self in pairs(minetest.luaentities) do
        if self._name and pmb_mob_spawn.mob[self._name] then
            me.add_to_cap(self._name)
        end
    end
end

-- try to spawn a random mob at a location
function me.spawn_mob_at(pos)
    local mob_name = me.get_spawn_mob(pos)
    if (not mob_name) or not minetest.registered_entities[mob_name] then return false end

    local mob_obj = minetest.add_entity(pos, mob_name)
    -- me.add_to_cap(mob_name)
    local self = mob_obj:get_luaentity()

    -- do the mob's spawn func
    if pmb_mob_spawn.mob[mob_name].on_spawn then
        pmb_mob_spawn.mob[mob_name].on_spawn(self, pos)
    end

    return self
end

function me.find_ground_at(pos, max_search)
    for i=0, max_search or 10 do
        local p = vector.offset(pos, 0, -i, 0)
        local node = minetest.get_node(p)
        if minetest.registered_nodes[node.name].walkable then
            if minetest.get_item_group(node.name, "full_solid") > 0 then
                return vector.offset(pos, 0, -i + 1, 0)
            else
                return false -- don't spawn in walkable nodes, but require full nodes in order to spawn
            end
        end
    end
    return false
end

function me.can_despawn(self)
    local name = self._name
    local pos = self.object:get_pos()
    if self._no_despawn == true then return false end
    -- force to despawn after a certain dist
    if pos and not pmb_mob_spawn.has_player_in_range(pos, 0, me.despawn_dist_force) then
        return true
    -- don't despawn if close to player
    elseif pos and pmb_mob_spawn.has_player_in_range(pos, 0, me.despawn_dist) then
        return false
    end
    -- figure out based on the custom func if it can despawn
    local can_despawn = (pmb_mob_spawn.mob[name].can_despawn and pmb_mob_spawn.mob[name].can_despawn(self))
    -- do it slowly, by using a random chance
    if math.random() < me.despawn_chance and can_despawn then
        return true
    end
    -- if all else fails, don't despawn
    return false
end

function me.despawn_all()
    for _, self in pairs(minetest.luaentities) do
        if self._name then
            if not pmb_mob_spawn.mob[self._name] then break end

            if me.can_despawn(self) then
                -- me.take_from_cap(self._name)
                self.object:remove()
            end
        end
    end
end

minetest.register_abm({
    label = "pmb_mob_spawn:main_spawner",
    nodenames = {"air"},
    interval = 10,
    chance = 10000,
    action = function(pos, node, active_object_count, active_object_count_wider)
        pmb_util.did_abm("mob spawn")
        if not me.enabled then return false end
        local ground = me.find_ground_at(pos)
        if not ground then return false end
        local mob = me.spawn_mob_at(ground)
    end
})

-- hard recalculate the mobcap sometimes
-- local recalc_timer = 5
-- minetest.register_globalstep(function(dtime)
--     recalc_timer = recalc_timer - dtime
--     if recalc_timer < 0 then
--         me.recalculate_cap()
--         recalc_timer = recalc_timer + (4)
--         minetest.log("HARD "..tonumber(me.cap.hostile.cur))
--     end
-- end)

-- despawn mobs
local despawn_timer = 1
minetest.register_globalstep(function(dtime)
    despawn_timer = despawn_timer - dtime
    if despawn_timer < 0 then
        despawn_timer = despawn_timer + 5
        me.despawn_all()
        if me.cap.hostile.cur < 0 then
            minetest.log("Error! Hostile Mob Count: "..me.cap.hostile.cur..". Obviously that shouldn't be possible. Recalculating...")
            me.recalculate_cap()
        end
    end
end)

-- minetest.after(2, me.recalculate_cap)
