

if pmb_mob_spawn then
    pmb_mob_spawn.register_mob({
        name = "pmb_kelar:kelar",
        groups = {"hostile", "pmb_kelar"},
        biomes = {},
        on_spawn = function(self, pos)
        end,
        can_spawn = function(pos, spawn_info)
            if not pmb_dimensions.is_in("overworld", pos) then return false end
            if not pmb_mob_spawn.has_head_room(pos, 2) then return false end
            if (pmb_mob_spawn.has_light(pos, 0, 7) and (math.random()<0.2 or pmb_mob_spawn.has_natural_light(pos, 0, 7))) then
                if pmb_entity_api.has_mobs_in_radius(pos, 40, {"pmb_kelar:kelar"}, 0, 1) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            if self._age and self._age < 20 then return false end
            return true
        end,
    })
    local biomes = {
        underworld = true,
        underworld_bridges = true,
        underworld_coral = true,
    }
    pmb_mob_spawn.register_mob({
        name = "pmb_kelar:kelar_underworld",
        groups = {"hostile", "pmb_kelar"},
        biomes = {},
        on_spawn = function(self, pos)
        end,
        can_spawn = function(pos, spawn_info)
            if math.random() < 0.90 then return false end
            if not pmb_dimensions.is_in("underworld", pos) then return false end
            if not biomes[minetest.get_biome_name(minetest.get_biome_data(pos).biome)] then return false end
            if minetest.get_item_group(minetest.get_node(vector.offset(pos, 0, -1, 0)).name, "lava_rock") == 0 then return false end
            if not pmb_mob_spawn.has_head_room(pos, 2) then return false end
            if pmb_mob_spawn.has_light(pos, 0, 7) then
                if pmb_entity_api.has_mobs_in_radius(pos, 100, {"pmb_kelar:kelar_underworld"}, 0, 1) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            if self._age and self._age < 20 then return false end
            return true
        end,
    })
    pmb_mob_spawn.cap.pmb_kelar.max = 20
end
