
pmb_cooking.node_sounds = {}
local node_sounds = pmb_cooking.node_sounds

function pmb_cooking.do_node_sound(pos, sound_name)
    local index = tostring(pos)
    if (not node_sounds[index]) or node_sounds[index].timer < 0 then
        node_sounds[index] = {handle = 0, timer = 10}
        local sound
        local node = minetest.get_node(pos)
        node = minetest.registered_nodes[node.name]
        if node._custom_sounds then
            sound = node._custom_sounds[sound_name or "passive"]
        end
        if not sound then return end
        local name = sound.name or ""
        sound = table.copy(sound)
        sound.pos = pos

        node_sounds[index].handle = minetest.sound_play(name, sound)
    end
end
function pmb_cooking.stop_node_sound(pos)
    local index = tostring(pos)
    if node_sounds[index]
    and node_sounds[index].handle then
        minetest.sound_stop(node_sounds[index].handle)
    end
    node_sounds[index] = nil
end

function pmb_cooking.node_sound_step(dtime)
    for index, sound in pairs(node_sounds) do
        sound.timer = sound.timer - dtime
        if sound.timer < 0 then
            minetest.sound_stop(node_sounds[index].handle)
            node_sounds[index] = nil
        end
    end
end

minetest.register_globalstep(pmb_cooking.node_sound_step)
