local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node('pmb_underworld:arlior_brick', {
    description = pmb_util.desc(S("Arlior Bricks"), "green"),
    groups = { full_solid = 1, item_arlior_brick = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_arlior_brick.png"},
    sounds = pmb_sounds.default_stone(),
})
if true then
    local s = "pmb_underworld:arlior"
    minetest.register_craft({
        output = "pmb_underworld:arlior_brick 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:arlior_brick")


minetest.register_node('pmb_underworld:arlior_brick_fine', {
    description = pmb_util.desc(S("Fine Arlior Bricks"), "green"),
    groups = { full_solid = 1, item_arlior_brick_fine = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_arlior_brick_fine.png"},
    sounds = pmb_sounds.default_stone(),
})
if true then
    local s = "pmb_underworld:arlior"
    local g = "pmb_underworld:arlior_brick"
    minetest.register_craft({
        output = "pmb_underworld:arlior_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:arlior_brick_fine")


minetest.register_node('pmb_underworld:arlior_brick_ornate', {
    description = pmb_util.desc(S("Ornate Arlior Bricks"), "green"),
    groups = { full_solid = 1, item_arlior_brick_ornate = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_arlior_brick_ornate_top.png", "pmb_underworld_arlior_brick_ornate_top.png", "pmb_underworld_arlior_brick_ornate.png", },
    sounds = pmb_sounds.default_stone(),
    paramtype2 = "facedir",
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        pmb_util.rotate_and_place_against(pos, placer, itemstack, pointed_thing, {offset = 0})
    end,
})
if true then
    local s = "pmb_underworld:arlior_brick"
    minetest.register_craft({
        output = "pmb_underworld:arlior_brick_ornate 3",
        recipe = {
        {s},
        {s},
        {s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:arlior_brick_ornate")


minetest.register_node('pmb_underworld:arlior_brick_lamp', {
    description = pmb_util.desc(S("Arlior Lamp"), "green"),
    groups = { full_solid = 1, item_arlior_brick_ornate = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_arlior_brick_lamp.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = 10,
})
if true then
    local s = "pmb_underworld:arlior_brick"
    local m = "pmb_underworld:arlior_mushroom_blue"
    minetest.register_craft({
        output = "pmb_underworld:arlior_brick_lamp 8",
        recipe = {
        {s, s, s},
        {s, m, s},
        {s, s, s},
        },
    })
end

pmb_util.register_all_shapes("pmb_underworld:arlior_brick_lamp")