
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

if pmb_biomes.flowers ~= nil then

local o = 0.02
local p = 0.1

minetest.register_decoration({
    name = "pmb_flora:flower_red",
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -p + o,
        scale = p,
        spread = {x = 7, y = 7, z = 7},
        seed = 9886,
        octaves = 3,
        persist = 0.2
    },
    biomes = pmb_biomes.flowers,
    y_max = alt_max,
    y_min = sealevel + 1,
    decoration = "pmb_flora:flower_red",
})

minetest.register_decoration({
    name = "pmb_flora:flower_white",
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -p + o,
        scale = p,
        spread = {x = 7, y = 7, z = 7},
        seed = 9886,
        octaves = 3,
        persist = 0.2
    },
    biomes = pmb_biomes.flowers,
    y_max = alt_max,
    y_min = sealevel + 1,
    decoration = "pmb_flora:flower_white",
})

minetest.register_decoration({
    name = "pmb_flora:flower_yellow",
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -p + o,
        scale = p,
        spread = {x = 7, y = 7, z = 7},
        seed = 9886,
        octaves = 3,
        persist = 0.2
    },
    biomes = pmb_biomes.flowers,
    y_max = alt_max,
    y_min = sealevel + 1,
    decoration = "pmb_flora:flower_yellow",
})

end