local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

pmb_warning = {}

local tmpstr = "\
This game is in development. Expect sporadic, game-breaking, world corrupting[n]\
updates to happen indesciminately and at random. Assume that updating to the[n]\
next version will corrupt all worlds irreversably. The entire design and structure[n]\
of the game may change without notice.[n] [n]\
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀You have been warned!"

local labels = ""

for i, substr in ipairs(string.split(tmpstr, "[n]")) do
    labels = labels.."label[8,"..(i * 0.3 + 4 - 0.3)..";"..substr.."]"
end

local formspec = ""..
    "size[24.00,12.0]"..
    "bgcolor[#000000]"..
    "style_type[image_button;bgimg=blank.png;bgimg_hovered=blank.png]"..
    "style_type[image_button;border=false]"..
    "image[10.2,3.5;4,1;pmb_warning.png]"..
    labels..
    "image_button[10,7;4,1;gm_windmills_button_start.png;".."start".."; Ok]"


minetest.register_on_joinplayer(function(player, last_login)
    if not last_login then
        minetest.show_formspec(player:get_player_name(), "pmb_warning", formspec)
    end
end)

pmb_util.formspec_actions.register_on_form_fields("pmb_warning", function(player, formname, fields)
    if fields.start then
        minetest.close_formspec(player:get_player_name(), formname)
    end
end)
