local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local function use_spear(itemstack, user, pointed_thing)
    if pmb_combat.cooldown.can_use(itemstack) then
        itemstack = pmb_combat.cooldown.wear_start(itemstack, "windup")
        minetest.sound_play(("pmb_fenn_spear_draw"), {
            gain = 0.5,
            object = user,
            max_hear_distance = 100,
            pitch = (math.random()*0.1) + 0.90
        })
    end
    return itemstack
end

minetest.register_tool("pmb_fenn:spear", {
    description = S("Fenn Spear"),
    inventory_image = "pmb_fenn_spear_inv.png",
    groups = { not_in_creative_inventory = 1 },
    on_secondary_use = function(itemstack, user, pointed_thing)
        if pmb_combat.cooldown.is_ready(itemstack) then
            player_model.set_anim(user, {tag="pmb_fenn_spear_aim", actions={"aim"}})
            return use_spear(itemstack, user, pointed_thing)
        end
        return itemstack
    end,
    on_place = function(itemstack, user, pointed_thing)
        if (not user) or (not minetest.is_player(user)) then return end
        if pmb_combat.cooldown.is_ready(itemstack) then
            player_model.set_anim(user, {tag="pmb_fenn_spear_aim", actions={"aim"}})
            return use_spear(itemstack, user, pointed_thing)
        end
        return itemstack
    end,
    -- on_use = function(itemstack, user, pointed_thing)
    --     if pointed_thing and pointed_thing.ref then
    --         pmb_statusfx.apply_status(pointed_thing.ref, "poison_3", 8, {})
    --     end
    -- end,
    _prj_speed = 40,
    _wield3d_visual = "mesh",
    _wield3d_mesh = "pmb_fenn_spear.b3d",
    _wield3d_textures = "pmb_fenn_spear.png",
    _wield3d_rotation = {x=0, y=-60, z=-90},
    _wield3d_offset = {x=0, y=9.0, z=1},
    _wield3d_scale = {x=0.5, y=0.5, z=0.5}
})

pmb_combat.cooldown.register_cooldown("pmb_fenn:spear", {
    cooldown = 3,
    windup = 1,
    on_cooldown_complete = function(player, itemstack)
        wield3d.update(player, {
            _wield3d_visual = "mesh",
            _wield3d_mesh = "pmb_fenn_spear.b3d",
            _wield3d_textures = "pmb_fenn_spear.png",
            _wield3d_rotation = {x=0, y=-60, z=-90},
            _wield3d_offset = {x=0, y=9.0, z=1},
            _wield3d_scale = {x=0.5, y=0.5, z=0.5}
        })
        return itemstack
    end,
})

pmb_util.register_on_wield({
    name = "pmb_fenn:spear",
    on_change_to_item = function(player, tostack)
    end,
    on_change_from_item = function(player, fromstack)
        player_model.unset_anim(player, "pmb_fenn_spear_aim")
    end,
    on_step = function(player, dtime, itemstack)
        local just_thrown = false
        itemstack, just_thrown = pmb_combat.throwable.on_wield_throwable(player, "pmb_fenn:spear_ENTITY", itemstack, {
            allow_partial_throw = true
        })
        if just_thrown then
            wield3d.update(player, {
                _wield3d_textures = "blank.png",
            })
            player_model.unset_anim(player, "pmb_fenn_spear_aim")
            minetest.sound_play(("pmb_fenn_spear_throw"), {
                gain = 0.9,
                object = player,
                max_hear_distance = 50,
                pitch = (math.random()*0.1) + 0.90
            })
        end
        return itemstack
    end,
})
