local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

pmb_mob_spawn = {
               enabled = false,
            spawn_dist = {min=30, max=110}, -- spawns can happen in this range
    despawn_dist_force = 128, -- mobs always despawn at this dist
          despawn_dist = 70, -- mobs sometimes despawn at this dist
        despawn_chance = 0.03,
                mobcap = 100, -- hard max for all mobs of any type
          spawn_rarity = 1, -- per second
           spawn_tries = 5, -- tries per sec
               version = 1
}

pmb_mob_spawn.enabled = minetest.settings:get_bool("pmb_mob_spawning") or false

local save_enabled = world_storage.get("pmb_mob_spawn", "enabled")
if save_enabled ~= nil then
    pmb_mob_spawn.enabled = save_enabled
end

-- contains all grouped caps
pmb_mob_spawn.cap = {
        all = {max = 100, cur = 0},
    hostile = {max = 40, cur = 0},
    passive = {max = 20, cur = 0},
}

dofile(mod_path .. DIR_DELIM .. "spawn_rule_register.lua")
dofile(mod_path .. DIR_DELIM .. "spawn_rule_helpers.lua")
dofile(mod_path .. DIR_DELIM .. "spawner.lua")

minetest.register_chatcommand("mob_spawning", {
    params = "",
    description = S("Turns on or off mob spawning"),
    privs = { server = 1 },
    func = function(name, param)
        if param == "off" then
            pmb_mob_spawn.enabled = false
            world_storage.set("pmb_mob_spawn", "enabled", pmb_mob_spawn.enabled)
        elseif param == "on" then
            pmb_mob_spawn.enabled = true
            world_storage.set("pmb_mob_spawn", "enabled", pmb_mob_spawn.enabled)
        else
            return true, "Mob spawning for this world is currently |" ..
            ((pmb_mob_spawn.enabled and "enabled") or "disabled") .. "|"
        end
        return true, "Mob spawning for this world has been set to |" ..
        ((pmb_mob_spawn.enabled and "enabled") or "disabled") .. "|"
    end
})
