# Parity of the Minor Bearing
A game about worldbuilding, homeliness, exploration and more.

![](https://codeberg.org/Possible_MT_Blockgame/Possible_MT_Blockgame/raw/branch/master/mods/pmb_core/pmb_warning/textures/pmb_warning.png)

# WARNING
This game is **in development**. Expect **sporadic**, game-breaking, **world corrupting** updates to happen **indesciminately and at random**. Assume that updating to the next version will **corrupt all worlds irreversably**. The entire design and structure of the game may change without notice.
You have been warned.

Until it reaches a releasable state, you can readily assume any individual part of the game is a **placeholder** and many things will be unpolished and jank.


### Compatible with mte 5.6+. Other versions unknown. Definitely doesn't work on 4.x
Always using the newest version, assume no backwards compatibility.



# What kind of game is it?
It is a sandbox, mechanic-centred world building game. The style or setting is early gunpowder era with low fantasy elements (think LoTR level magic at most). The focus is on the player **building**, exploring and defending their own **home and world**. **World building** and creating a place for yourself is what it should be best at. It is not about mining for materials or grinding for better gear, it is about constructing an immersive and meaningful place in a world.

There is a minimal amount of reward or progression. The playing of the game **_is_** the reward. The activities in the game **_are_** *the reason to play it*.



# Contributing
## Bug Reports and issues
For bug reports, use the format below and copy it into a new issue. Bug report titles should describe the problem, and suggestions should provide the affirmative. Examples are (bug) "Opening storage with armor equipped causes crash" and (suggestion) "Animals will be afraid of powerful creatures".
For bug reports:
```md
-- -- -- --
## Version
VERSION_OR_GIT_TAG_HERE
## Crash error if applicable
``deletethistext`
ERROR_GOES_HERE
``deletethistext`
## Current behavior and steps to reproduce it
- 
- 
## Expected behavior
- 
- 
-- -- -- --
[your description and extra details here if you want]

```


## Contributing code
Approval for any PRs is **extremely strict** in **game design** and **direction** requirements, in **licensing** and in **code structure**. This is a game designed and built mostly by a single person, and with a very specific goal and direction in mind.

That said, more ideas is good, and if you have ideas that fit the design principles below, talk about it on the [discord](https://discord.gg/nCkMY5wug7) or open an issue (make sure someone hasn't made one about the same thing before).


In case you *really* want to contribute to this repo, here is a template to use. It is best to discuss potential changes and additions first, else you might waste time on something that won't ever be added.
### Contribution Template
```md
-- -- -- --
Pull Request
-- -- -- --
I offer all changes to existing files under {license name}.
I {have / have not} added a submodule and therefore a LICENSE file within its folder.
I {have you?} read the *Design Information and Guide*, and these changes have been compared to those principles and fit with them.
I have properly included licenses for all media and/or code, and all media and code are permissively licensed as attribution or less restrictive.
-- -- -- --

Summary of things added or changed:
- thing 1
- thing 2 [...]
```


# LICENSES and copyleft
If a commit contains copyleft licensed material, or any licensed material that would require use to re-license this entire project under someone else's copyright, that commit will be reverted. If in a PR it will be rejected. Developers of the project should be able to fork at any point without legal problems and use the code for any purpose.

No licenses with restrictions on use; no CC-BY-SA-NC for example. MIT, 0BSD or CC0 is preferred.
Avoid BY-SA. It is legally difficult, and no-one really knows for sure if it's copyleft or not, so just don't use it.

Free and open source. Free as in freedom, not free as in "free but you do as we tell you".



# Design Information and Guide
As a general design philosophy:
> **all player activity in the game** should contain reward which is **inherent** to the activity itself, and not injected by the designer

or:

> a reward that is not given by the designer, but **inherent** to the activity itself is good

> a reward given by the designer and **not** always inherent to the activity is bad

> a reward given is often able to **overshadow** inherent reward

This could also be phrased as hypotheticals. There are a few levels, 1 being best:

> 1. could I do this activity for some time, then delete the world and still feel like the whole thing was enjoyable?
> 2. if I did this activity for a while, and then left it in the world and moved on to somewhere else without taking anything with me, would it still feel like it was an enjoyable time spent? (e.g. build a house and then leave)
> 3. would I open the game to do specifically this activity rather than it being just a necessary step to another thing which itself is the real goal? (e.g. mining, but you don't open the game for mining, you open it to mine only to *get better tools*)

If it fails (3) then it's not good enough. Passing (1) is best. If at any stage of playtesting we think (3) and the answer is no, we should remove or redesign whatever activity it is.

For example, solving a puzzle is fun in its own right and fits this principle, but solving a puzzle because it gives you a better item does not fit this principle.
Do not reward the player extrinsically; it should be that the playing of the game **_is_** the reward. The activities in the game **are** *the reason to play it*.



## Main Design Principles
1. Sandbox
	- every part of the game should be at least mostly optional, have multiple ways to achieve the same thing, no arbitrary goals set by the devs
	- avoid items and resources that are clearly necessary but hard to get (no cases of Terraria's rod of discord!)
2. Fun
	- design and mechanics should encourage behaviors in the player that are fun
	- don’t add things that encourage the player to do boring tasks or that encourage the game to be exploited in a boring way
	- exploiting the game in fun, fair ways = good
3. Emergent
	- features should interact due to being independent and generalized instead of specific (content vs mechanics)
	- adding something that has interactions with two other things means we get very rich gameplay possibilities just from adding one thing, because those two things each interact with two other things and so on
4. Fair
	- there should be an obvious cause --> effect, rather than random inconveniences
	- don't punish the player, but have obvious and foreseeable consequences
5. Abstracted
	- simulation should be avoided unless *absolutely necessary* for the mechanic to work (i.e. wiring is simulated, but we don’t need to simulate air pressure so we know if the player is hot and needs to drink more water - that would be oversimulated)
	- needing to drink water at all is also oversimulated
	- ask "does this make gameplay more interesting" and not from a developer standpoint but from a player's perspective



## More Design Principles
1. features should be generalised and interact with other features
	- instead of adding an arrow shooter node, add nodes which can shoot anything that’s a projectile
	- to prevent you from shooting all projectiles, allow the projectile definition to choose whether it can be shot from a node
2. specific mechanics that only have one use can be made a branching feature
	- if we have a mob in the game meant to just be a threat and nothing more, we could make it drop something useful like leather
3. the player should not be encouraged by the game to play in a boring or monotonous way
	- no grinding
4. the player should not be forced to play in a varied way
	- e.g. making a crafting recipe for a powerful item that arbitrarily makes the player need to go to every biome in the game
	- making the world varied is good, but there should not be progression tree spaghetti, nor any real progression tree at all
5. mechanics that require the player to complete more tasks should be interrogated
	- this should not be arbitrary, it should interact with other parts of the game and for a reason and be inherently enjoyable
	- example, don't add crafting recipes just to slow the player down on the way to crafting something cool, instead, make the items be interactive within the game
6. the player should not be punished by the game for wanting to do something
	- obstacles are fine, but just "making things harder" for no reason adds nothing
	- never try to prevent behavior by punishment; people can't play it "the wrong way" unless it's boring (see Main Design Principles)
