local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local formspec = [[
  size[10,4]
  list[context;main;0,0;10,3;]
  list[current_player;main;0,5;8,4;]
]]

local function set_up_inventory(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  inv:set_size("main", 10*3)
  meta:set_string("formspec",
      "size[24.00,12.0]"..
      "background["..(5.5)..","..(2.5)..";"..(11)..","..(4)..";pmb_inv_bg.png^[opacity:100]"..
      ((pmb_inventory and pmb_inventory.get_itemslot_array(6, 3, 10, 3)) or "")..
      "list[context;main;6,3;10,3;]"..
      pmb_inventory.player.get_formspec(nil)
  )
  meta:set_string("infotext", "Chest");
end

minetest.register_node('pmb_storage:chest', {
  description = pmb_util.desc(S("Wooden Chest"), "grey"),
  _tt_long_desc = S("Stores items."),
  groups = { oddly_breakable_by_hand = 2, choppy = 1, solid = 1, suffocates = 0, wood = 1, item_wooden_chest = 1, storage = 1, chest = 1 },
  tiles = {"pmb_storage_chest.png"},
  mesh = "pmb_storage_chest.b3d",
  drawtype = "mesh",
  sounds = pmb_sounds.default_wood(),
  paramtype2 = "facedir",
  after_place_node = function(pos, placer, itemstack, pointed_thing)
    pmb_util.rotate_and_place_from(pos, placer, itemstack, pointed_thing)
  end,
  on_construct = function(pos)
    set_up_inventory(pos)
  end,
  on_destruct = function(pos)
    pmb_inventory.drop_contents(pos)
  end,
  _on_node_update = function(pos, cause)
    if cause == "place" then
      set_up_inventory(pos)
      return true
    end
  end
})


if true then
  pmb_tcraft.register_group_craft({
      output = "pmb_storage:chest",
      items = {},
      group = "planks",
      group_count = 8
  })
end
