local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node('pmb_underworld:lava_brick', {
    description = pmb_util.desc(S("Lava Bricks"), "grey"),
    groups = { full_solid = 1, item_lava_brick = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_lava_brick.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light,
})
if true then
    local s = "pmb_underworld:lava_rock"
    minetest.register_craft({
        output = "pmb_underworld:lava_brick 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:lava_brick")


minetest.register_node('pmb_underworld:lava_brick_fine', {
    description = pmb_util.desc(S("Fine Lava Bricks"), "grey"),
    groups = { full_solid = 1, item_lava_brick_fine = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_lava_brick_fine.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light,
})
if true then
    local s = "pmb_underworld:lava_rock"
    local g = "pmb_underworld:lava_brick"
    minetest.register_craft({
        output = "pmb_underworld:lava_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:lava_brick_fine")


minetest.register_node('pmb_underworld:lava_brick_ornate', {
    description = pmb_util.desc(S("Ornate Lava Bricks"), "grey"),
    groups = { full_solid = 1, item_lava_brick_ornate = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_lava_brick_ornate.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light,
})
if true then
    local s = "pmb_underworld:lava_brick"
    minetest.register_craft({
        output = "pmb_underworld:lava_brick_ornate 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:lava_brick_ornate")


minetest.register_node('pmb_underworld:lava_brick_lamp', {
    description = pmb_util.desc(S("Lava Brick Lamp"), "grey"),
    groups = { full_solid = 1, item_lava_brick_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = pmb_util.node_light_unfck("pmb_underworld_lava_brick_lamp.png"),
    sounds = pmb_sounds.default_stone(),
    light_source = 14,
})
if true then
    local s = "pmb_underworld:lava_brick"
    local l = "pmb_underworld:glow_rock"
    minetest.register_craft({
        output = "pmb_underworld:lava_brick_lamp 8",
        recipe = {
        {s, s, s},
        {s, l, s},
        {s, s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:lava_brick_lamp")


minetest.register_node('pmb_underworld:lava_brick_pillar', {
    description = pmb_util.desc(S("Lava Brick Pillar"), "grey"),
    groups = { full_solid = 1, item_lava_brick_pillar = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_lava_brick_pillar_top.png", "pmb_underworld_lava_brick_pillar_top.png", "pmb_underworld_lava_brick_pillar.png", },
    sounds = pmb_sounds.default_stone(),
    paramtype2 = "facedir",
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        pmb_util.rotate_and_place_against(pos, placer, itemstack, pointed_thing, {offset = 0})
    end,
    light_source = pmb_underworld.lava_rock_light,
})
if true then
    local s = "pmb_underworld:lava_brick"
    minetest.register_craft({
        output = "pmb_underworld:lava_brick_pillar 3",
        recipe = {
        {s},
        {s},
        {s},
        },
    })
end


minetest.register_node('pmb_underworld:lava_brick_coral', {
    description = pmb_util.desc(S("Coral Covered Lava Bricks"), "grey"),
    groups = { full_solid = 1, item_lava_brick_coral = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_lava_brick_coral.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light,
})
if true then
    local s = "pmb_underworld:lava_brick"
    local g = "pmb_underworld:glow_rock"
    minetest.register_craft({
        output = "pmb_underworld:lava_brick_coral 4",
        recipe = {
        {s, g},
        {g, s},
        },
    })
end