
local hand_groupcap = {
    oddly_breakable_by_hand = {
        max_drop_level = 2,
        times = { 0.7, 1.4, 3, 7, 30, 120, 360 },
        uses = 0,
    },
    cracky = {
        max_drop_level = 0,
        times = { 3, 7, 30, 120, 360 },
        uses = 0,
    },
    crumbly = {
        max_drop_level = 3,
        times = { 0.7, 1.4, 3, 7, 30, 120, 360 },
        uses = 0,
    },
    choppy = {
        max_drop_level = 3,
        times = { 0.7, 1.4, 3, 7, 30, 120, 360 },
        uses = 0,
    },
    snappy = {
        max_drop_level = 4,
        times = { 0.7, 1.4, 3, 7, 30, 120, 360 },
        uses = 0,
    },
}

local hand_damage_groups = {
    blunt=1,
}

if minetest.is_creative_enabled("") then
    hand_groupcap = {
        oddly_breakable_by_hand = {
            times = { 0.1, 0.1, 0.1, 0.1 },
            uses = 0,
        },
        cracky = {
            times = { 0.1, 0.1, 0.1, 0.1 },
            uses = 0,
        },
        crumbly = {
            times = { 0.1, 0.1, 0.1, 0.1 },
            uses = 0,
        },
        choppy = {
            times = { 0.1, 0.1, 0.1, 0.1 },
            uses = 0,
        },
        snappy = {
            times = { 0.1, 0.1, 0.1, 0.1 },
            uses = 0,
        },
    }
    hand_damage_groups = {
        fleshy = 999,
        cracky = 999,
        choppy = 999,
        snappy = 999,
        crumbly = 999,
    }
elseif pmb_vars.prevent_hand_digging then
    hand_groupcap = {
        oddly_breakable_by_hand = {
            maxlevel = 0,
            uses = 0,
        },
        cracky = {
            maxlevel = 0,
            uses = 0,
        },
        crumbly = {
            maxlevel = 0,
            uses = 0,
        },
        choppy = {
            maxlevel = 0,
            uses = 0,
        },
        snappy = {
            maxlevel = 0,
            uses = 0,
        },
        dig_immediate = {
            maxlevel = 0,
            uses = 0,
        },
    }
end

--  add hand tool
minetest.override_item("", {
    wield_image = "hand.png",
    wield_scale = { x = 3, y = 3, z = 5 },
    tool_capabilities = pmb_util.register_tool_cap("__hand", {
        full_punch_interval = 0.5,
        groupcaps = hand_groupcap,
        damage_groups = hand_damage_groups,
    }),
})
