
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "boulder_valley"

pmb_biomes.register_biome({
    name = this_biome,

    node_top = 'pmb_soil:forest_dirt',--_with_grass',
    depth_top = 1,

    node_filler = 'pmb_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'pmb_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 30,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 9,

    heat_point = 23,
    humidity_point = 62,
}, {"light_scrub", "ash", "boulders", "overworld"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_sch.get_schematic_path

pmb_biomes.add_boulders({this_biome}, 0.5)

-- ORES

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_stone:cobble",
    wherein		= {"group:soil"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_min		= -100,
    y_max		= 3000,
    noise_params = {
        offset  = 0.01,
        scale   = 1,
        spread  = {x=250, y=250, z=250},
        seed    = 12345,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_stone:cobble",
    wherein		= {"group:soil"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_stone:stone",
    wherein		= {"group:soil"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    noise_params = {
        offset  = 0.01,
        scale   = 1,
        spread  = {x=20, y=250, z=20},
        seed    = 67576,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_stone:cobble_moss_1",
    wherein		= {"pmb_soil:forest_dirt"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    noise_params = {
        offset  = 0.01,
        scale   = 1,
        spread  = {x=20, y=250, z=20},
        seed    = 453,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_stone:cobble_moss_1",
    wherein		= {"pmb_stone:cobble"},
    clust_scarcity	= 250,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_stone:cobble_moss_2",
    wherein		= {"pmb_stone:cobble_moss_1"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})



-- trees
if true then
    -- oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.0007,
        scale = 0.0015,
        spread = {x = 10, y = 10, z = 10},
        seed = 654,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.0007,
        scale = 0.0015,
        spread = {x = 10, y = 10, z = 10},
        seed = 654,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.0007,
        scale = 0.0015,
        spread = {x = 10, y = 10, z = 10},
        seed = 654,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.0015,
        scale = 0.0010,
        spread = {x = 10, y = 10, z = 10},
        seed = 7856,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.003,
        scale = 0.009,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.003,
        scale = 0.007,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1
})
end


