
local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(minetest.get_current_modname())

pmb_map_base = {}


pmb_biomes = {}
pmb_biomes.registered = {}

function pmb_biomes.register_biome(biome, groups)
    -- pmb_biomes[biome.name] = groups
    pmb_biomes.registered[biome.name] = 1
    minetest.register_biome(biome)
    for _, group in pairs(groups) do
        if not pmb_biomes[group] then
            pmb_biomes[group] = {biome.name}
        else
            pmb_biomes[group][#pmb_biomes[group]+1] = biome.name
        end
    end

    if biome.y_min_ocean and (not biome.__has_reg) then
        biome.__has_reg = true
        biome.y_max = biome.y_min - 1
        biome.y_min = biome.y_min_ocean
        biome.name = biome.name.."_ocean"
        biome.node_top = biome.node_riverbed
        biome.vertical_blend = biome.ocean_vertical_blend or 3
        pmb_biomes.register_biome(biome, groups)
    end
end


dofile(mod_path .. DIR_DELIM .. "structure_spawning" .. DIR_DELIM .. "cabins.lua")
dofile(mod_path .. DIR_DELIM .. "structure_spawning" .. DIR_DELIM .. "ruins.lua")
dofile(mod_path .. DIR_DELIM .. "structure_spawning" .. DIR_DELIM .. "boulders.lua")

dofile(mod_path .. DIR_DELIM .. "aliases.lua")
dofile(mod_path .. DIR_DELIM .. "biomes.lua")
dofile(mod_path .. DIR_DELIM .. "ores" .. DIR_DELIM .. "soil_types.lua")
dofile(mod_path .. DIR_DELIM .. "ores.lua")


minetest.register_chatcommand("biome", {
        params = "",
        description = S("Tells the biome"),
        privs = {},
        func = function(name, param)
                local player = minetest.get_player_by_name(name)
                local p = player:get_pos()
                local b = minetest.get_biome_data(p)
                if not b then return false, S("No biome") end
                return true, S("Biome: "..minetest.get_biome_name(b.biome).."    Heat: "..b.heat.."    Humid: "..b.humidity)
        end
})
