



local function is_air_above(pos, limit)
    local v = vector.copy(pos)
    for i=1, limit do
        v = vector.offset(v, 0, 1, 0)
        local node = minetest.get_node(v)
        if not minetest.registered_nodes[node.name].buildable_to then
            return false
        end
    end
    return true
end

minetest.register_abm({
    nodenames = {"group:sapling"},
    interval = 32.0,
    chance = 20,
    action = function(pos, node, active_object_count, active_object_count_wider)
        pmb_util.did_abm("sapling")
        if is_air_above(pos, 12) then
            local tree_type = minetest.registered_nodes[node.name]._tree_type
            pmb_trees.grow_tree.general(pos, tree_type)
        end
    end
})


