local sealevel = pmb_underworld.sea_level
local alt_max = pmb_underworld.alt_max
local alt_min = pmb_underworld.alt_min
local sch = pmb_underworld.get_schematic_path

local this_biome = "pmb_underworld_arlior_meadow"

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local function do_grass_stuff(num, seed)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"pmb_underworld:arlioran"},
        sidelen = 16,
        noise_params = {
            offset = -0.0,
            scale = 0.05,
            spread = {x = 200, y = 200, z = 200},
            seed = seed,
            octaves = 3,
            persist = 0.2
        },
        biomes = { this_biome },
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "pmb_underworld:arlior_"..num,
        flags = "all_floors"
    })
end

do_grass_stuff("fola", 8765)

local function do_arlior_stuff(num, seed)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"pmb_underworld:arlioran"},
        sidelen = 2,
        noise_params = {
            offset = -1.6 - 0.08,
            scale = 1.8,
            spread = {x = 10, y = 10, z = 10},
            seed = seed,
            octaves = 3,
            persist = 0.1
        },
        biomes = { this_biome },
        y_max = alt_max,
        y_min = sealevel,
        decoration = "pmb_underworld:arlior_"..num,
        flags = "all_floors"
    })
end

do_arlior_stuff("stem", 43)

do_arlior_stuff("mushroom_blue", 876)
