local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local function use_bow(itemstack, user, pointed_thing)
    if pmb_combat.cooldown.can_use(itemstack) and itemstack:get_meta():get_string("_mode") ~= "windup" then
        itemstack = pmb_combat.cooldown.wear_start(itemstack, "windup")
        minetest.sound_play(("pmb_bow_draw"), {
            gain = 0.5,
            object = user,
            max_hear_distance = 100,
            pitch = (math.random()*0.1) + 0.90
        })
    end
    return itemstack
end

minetest.register_tool("pmb_bow:bow", {
    description = S("Bow"),
    wield_image = "pmb_bow.png",
    inventory_image = "pmb_bow_bar.png",
    groups = { weapon = 1 },
    on_secondary_use = function(itemstack, user, pointed_thing)
        if pmb_combat.cooldown.is_ready(itemstack) then
            player_model.set_anim(user, {tag="pmb_bow_bow_aim", actions={"aim"}})
            return use_bow(itemstack, user, pointed_thing)
        end
        return itemstack
    end,
    on_place = function(itemstack, user, pointed_thing)
        local ret = pmb_util.try_rightclick(itemstack, user, pointed_thing)
        if ret then
            player_model.unset_anim(user, "pmb_bow_bow_aim")
            if ret:get_name() == itemstack:get_name() then
                ret = pmb_combat.cooldown.wear_start(ret, "cooldown")
            end
            return ret
        end

        if (not user) or (not minetest.is_player(user)) then return end
        if pmb_combat.cooldown.is_ready(itemstack) then
            player_model.set_anim(user, {tag="pmb_bow_bow_aim", actions={"aim"}})
            return use_bow(itemstack, user, pointed_thing)
        end
        return itemstack
    end,
    wield_scale = vector.new(2, 2, 2),
    _prj_speed = 30,
})

pmb_combat.cooldown.register_cooldown("pmb_bow:bow", {
    cooldown = 0,
    windup = 1.5,
    on_cooldown_complete = function(player, itemstack)
        return itemstack
    end,
    on_windup_complete = function(player, itemstack)
        minetest.sound_play(("pmb_bow_draw_complete"), {
            gain = 0.9,
            object = player,
            max_hear_distance = 50,
        })
    end,
})

pmb_util.register_on_wield({
    name = "pmb_bow:bow",
    on_change_to_item = function(player, tostack)
    end,
    on_change_from_item = function(player, fromstack)
        player_model.unset_anim(player, "pmb_bow_bow_aim")
        fromstack = pmb_combat.cooldown.wear_start(fromstack, "cooldown")
        return fromstack
    end,
    on_step = function(player, dtime, itemstack)
        local just_thrown = false
        itemstack, just_thrown = pmb_combat.throwable.on_wield_throwable(player, "pmb_bow:arrow_ENTITY", itemstack, {
            allow_partial_throw = true,
            min_windup = 0.5,
        })
        if just_thrown then
            wield3d.update(player, {
                _wield3d_textures = "blank.png",
            })
            player_model.unset_anim(player, "pmb_bow_bow_aim")
            minetest.sound_play(("pmb_bow_shoot"), {
                gain = 0.9,
                object = player,
                max_hear_distance = 50,
                pitch = (math.random()*0.1) + 0.90
            })
        end
        return itemstack
    end,
})

pmb_tcraft.register_craft({
    output = "pmb_bow:bow",
    items = {
        ["pmb_items:stick"] = 4,
        ["pmb_items:plant_fibre"] = 10,
    }
})
