
local vmax = pmb_underworld.alt_max
local vmin = pmb_underworld.alt_min

local size = 130

minetest.register_ore({
  ore_type       = "stratum",
  ore            = "pmb_stone:obsidian",   -- pmb_underworld:glow_rock -- pmb_stone:obsidian
  wherein        = {"pmb_underworld:worknode_soil", "pmb_underworld:worknode_topsoil", "pmb_underworld:worknode_dust"},
  y_min = vmin,
  y_max = vmax,
  clust_scarcity  = 1,
  noise_params    = {
    offset = vmin + vmax / 2,
    scale = math.abs(vmax - vmin) * 2,
    spread = {x = size, y = size, z = size},
    seed = 232,
    octaves = 5,
  },
  np_stratum_thickness = {
    offset = 100,
    scale = 200,
    spread = {x = 50, y = 50, z = 50},
    seed = 3242,
    octaves = 3,
    persistence = 0.7
  },
  stratum_thickness = 20,
  biomes = {"underworld", "underworld_coral", "underworld_bridges", "underworld_arlior_meadow"},
})


-- add lava
minetest.register_ore({
  ore_type       = "stratum",
  ore            = "pmb_nodes_surface:lava_source",
  wherein        = { "air", "pmb_underworld:worknode_dust" },
  y_min = pmb_underworld.alt_min,
  y_max = pmb_underworld.sea_level,
})

minetest.register_ore({
  ore_type       = "scatter",
  ore            = "pmb_underworld:glow_rock",
  wherein        = {"group:solid"},
  y_min = pmb_underworld.alt_min,
  y_max = pmb_underworld.alt_max,
  clust_scarcity = 1000,
  clust_num_ores = 4,
  clust_size     = 3,
  biomes = {"underworld", "underworld_coral", "underworld_bridges"},
})
