

local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

local size = 10



local function do_flax_stuff(num, seed)
    minetest.register_decoration({
        -- name = "pmb_flora:flax_"..num,
        deco_type = "simple",
        place_on = {"group:soil"}, -- only on grasslike nodes
        sidelen = 2,
        noise_params = {
            offset = -1.6 - num*0.02,
            scale = 1.8,
            spread = {x = size, y = size, z = size},
            seed = seed,
            octaves = 3,
            persist = 0.1
        },
        biomes = {"grasslands", "grasslands_valley"},
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "pmb_flora:flax_"..num,
    })
end


do_flax_stuff(0, 43)
do_flax_stuff(1, 43)
do_flax_stuff(2, 43)
do_flax_stuff(3, 43)


--mix with grass

local function do_grass_stuff(num, seed)
    minetest.register_decoration({
        -- name = "pmb_flora:grass_"..num.."_for_flax",
        deco_type = "simple",
        place_on = {"group:solid"}, -- only on grasslike nodes
        sidelen = 2,
        noise_params = {
            offset = -1.35,
            scale = 1.8,
            spread = {x = size, y = size, z = size},
            seed = seed,
            octaves = 2,
            persist = 0.2
        },
        biomes = {"grasslands", "grasslands_valley"},
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "pmb_flora:grass_"..num,
    })
end


do_grass_stuff(0, 43)
do_grass_stuff(1, 43)
do_grass_stuff(2, 43)
