
local pl = {}

local _offset = {x=1, y=0}
local function p(x,y)
    return tostring(x+_offset.x) .. "," .. tostring(y + _offset.y)
end

minetest.register_globalstep(function(dtime)
    for i, player in ipairs(minetest.get_connected_players()) do
        if not pl[player] then pl[player] = {scroll = 0, stash = {}} end
        for k, methodstash in pairs(pl[player].stash) do
            pl[player].stash[k].time = methodstash.time - dtime
        end
    end
end)

local function index_to_pos(c)
    return c
end

local function index_to_recipe_uid(player, method, index)
    return ((pl[player].craftable[method] or {})[index] or {}).uid
end

local scroll_per_formspec_unit = 11.65 -- magic number
local function scroll_position_to_index(scroll)
    -- return scroll
    return (scroll-3) / scroll_per_formspec_unit + 5.3
end

local function scroll_position_to_uid(player, method, scroll)
    local index = math.floor(scroll_position_to_index(scroll))
    return index_to_recipe_uid(player, method, index)
end

-- reverses the above
local function pos_to_scroll_position(pos)
    local ret = pos - 5.3
    ret = ret * scroll_per_formspec_unit
    return ret + 3
end

function pmb_inventory.tcraft_get_formspec(player, method)
    if not method then method = "normal" end
    if not pl[player] then pl[player] = {scroll = 0, stash = {}, craftable = {}} end

    if not pl[player].stash[method] then
        pl[player].stash[method] = {time = 1}
    elseif pl[player].stash[method].time > 0 and pl[player].stash[method].last_formspec ~= nil then
        return pl[player].stash[method].last_formspec
    else
        pl[player].stash[method].time = 2
    end

    local scroll = pl[player].scroll

    local fs = ""
    local pli = pmb_tcraft.get_player_craftable(player)
    pl[player].craftable[method] = {}
    local craftable = pl[player].craftable[method]
    for i, def in ipairs(pli.craftable) do
        if ((not def.method) and method == "normal") or table.indexof(def.method, method) > 0 then
            craftable[#craftable+1] = def
            if pl[player].last_viewed_uid == def.uid then
                -- minetest.log(pl[player].last_viewed_uid)
                -- minetest.log(def.output)
                scroll = pos_to_scroll_position(i) + (pl[player].scroll_offset or 0)
            end
        end
    end

    fs = fs ..
    "image["..p(0.25,0.15)..";1.425,12.25;pmb_tcraft_panel.png]"..
    "scrollbaroptions[arrows=hide;smallstep=30;thumbsize=100;max=1000]"..
    "scrollbar["..p(0.0,0.5)..";0.45,10;vertical;tcraft_scroll;"..tostring(scroll).."]"..
    "scroll_container["..p(0.9,1)..";3.81,11.35;tcraft_scroll;vertical;0.1]"..
    "style_type[item_image_button;bgcolor=#ffffff]"..
    "style_type[item_image_button;bgcolor=#ffffff;textcolor=#8c3f5d;border=false;bgcolor_pressed=#cccccc;bgcolor_hovered=#dddddd]"

    -- button to craft and visual for item crafted
    local c = 0
    fs = fs .. "style_type[item_image_button;bgimg=pmb_tcraft_bg.png;bgimg_hovered=pmb_tcraft_bg.png]"
    for k, recipe in ipairs(craftable) do
        local dims = "-0.1,"..tostring(index_to_pos(c))..";1,1;"

        fs = fs .. "item_image_button["..dims..recipe.output..";".."tcraftid_"..tostring(recipe.uid).."_1".."; ]"

        c = c + 1
    end

    -- visual for recipe ingredients
    fs = fs .. "style_type[item_image_button;bgimg=blank.png;bgimg_hovered=blank.png]"
    c = 0
    local id = 0
    for k, recipe in ipairs(craftable) do
        local l = 0.9
        for name, count in pairs(recipe.items) do
            fs = fs .. "item_image_button["..tostring(l)..","..tostring(index_to_pos(c)+0.1)..";0.5,0.5;"
            ..name..(count > 1 and " " or "")..tostring(count > 1 and count or "")..";tcinf_"..tostring(id).."; ]"
            l = l + 0.4
            id = id + 1
        end
        c = c + 1
    end

    -- x10 craft button
    fs = fs .. "style_type[image_button;bgimg=pmb_tcraft_x10.png;bgimg_hovered=pmb_tcraft_x10_hover.png]"
    fs = fs .. "style_type[image_button;border=false]"
    c = 0
    for k, recipe in ipairs(craftable) do
        local dims = ".70,"..tostring(index_to_pos(c)+0.6)..";0.4,0.4;"

        fs = fs .. "image_button["..dims.."blank.png;".."tcraftid_"..tostring(recipe.uid).."_10".."; ]"

        c = c + 1
    end

    fs = fs .. "scroll_container_end[]"
    pl[player].stash[method].last_formspec = fs
    return fs
end

function pmb_inventory.on_fields_tcraft(player, formname, fields)
    if not pl[player] then pl[player] = {scroll = 0} end

    for field, val in pairs(fields) do
        local _split = string.split(field, "_", false, 3)
        if _split and _split[1] == "tcraftid" then
            local uid = tonumber(_split[2] or "-1")
            local count = tonumber(_split[3] or "1")
            local success = pmb_tcraft.try_to_craft_uid(player, uid, count)
            pmb_tcraft.delay_recalc(player)

            if success then
                minetest.sound_play("pmb_pickup_item", {
                    gain = 0.3 + math.random() * 0.1,
                    to_player = player:get_player_name(),
                    pitch = 0.8 + math.random() * 0.2
                })
            else
                minetest.sound_play("pmb_not_allowed", {
                    gain = 0.2,
                    to_player = player:get_player_name(),
                })
            end
        end
    end
    if fields.tcraft_scroll then
        local scroll_event = minetest.explode_scrollbar_event(fields.tcraft_scroll)
        if scroll_event.type == "CHG" then
            pl[player].scroll = scroll_event.value
            pl[player].last_viewed_uid = scroll_position_to_uid(player, "normal", scroll_event.value)
            local sp = scroll_event.value / scroll_per_formspec_unit
            pl[player].scroll_offset = (math.ceil(sp) - sp) * scroll_per_formspec_unit
            pmb_tcraft.delay_recalc(player)
            -- minetest.log(scroll_position_to_index(scroll_event.value))
        end
    end
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "" then return end
    pmb_inventory.on_fields_tcraft(player, formname, fields)
end)

