


local damage_groups = {
    pierce=11,
    projectile=1,
}

local csize = 0.3
minetest.register_entity("pmb_fenn:spear_ENTITY", {
    initial_properties = {
        visual = "mesh",
        mesh = "pmb_fenn_spear.b3d",
        textures = {"pmb_fenn_spear.png"},
        stepheight = 0,
        hp_max = 1,
        physical = false,
        collisionbox = {
            -csize, -csize/4, -csize, csize, csize/4, csize,
        },
    },
    on_step = function(self, dtime)
        self._age = self._age + dtime
        if not self._pmb_stuck then
            self._rotation = self.object:get_rotation()
            pmb_combat.projectile.on_step(self, dtime, {})

            pmb_combat.projectile.rotate_to_trajectory(self, dtime)
        else
            self.object:set_velocity(vector.new(0,0,0))
            local checkpos = vector.add(
                self.object:get_pos(),
                vector.multiply(vector.normalize(self._prj_dir or vector.new(0,0,0)), 0.01))
            local node = minetest.get_node(checkpos)
            if not minetest.registered_nodes[node.name].walkable then
                self._pmb_stuck = false
            end
            if self._pmb_pop_off_timer and self._pmb_pop_off_timer > 0 then
                self._pmb_pop_off_timer = self._pmb_pop_off_timer - dtime
            else
                self._pmb_pop_off_timer = nil
                -- local drop_pos = vector.subtract(self.object:get_pos(), self._prj_dir)
                -- minetest.add_item(drop_pos, ItemStack("pmb_fenn:spear"))
                self.object:remove()
            end
        end
    end,
    _prj_can_collide = function(self, pointed_thing)
        if pointed_thing.type == "node" then
            local node = minetest.get_node(pointed_thing.under)
            if minetest.registered_nodes[node.name].walkable then
                return true
            end
        else
            return true
        end
    end,
    _prj_on_collide = function(self, pointed_thing)
        if pointed_thing.type == "node" then
            self.object:set_velocity(vector.new(0,0,0))
            self._pmb_pop_off_timer = 10
            self._pmb_stuck = true
            if pointed_thing.intersection_point then
                self.object:set_pos(pointed_thing.intersection_point)
            end
            minetest.sound_play(("pmb_fenn_spear_hit"), {
                gain = 1.0,
                pos = self._last_pos,
                object = self.object,
                max_hear_distance = 50,
                pitch = (math.random()*0.1) + 0.90
            })
            self.object:set_properties({
                physical = true
            })
            return true
        elseif (not self._prj_skip_objects) and pointed_thing.type == "object" and pointed_thing.ref ~= self._prj_owner then
            local tar = pointed_thing.ref
            tar:punch(
                self._prj_owner or self.object,
                1,
                {
                    damage_groups = self._prj_damage_groups,
                    full_punch_interval = 1,
                },
                self._avg_vel
            )
            self.object:set_velocity(vector.new(0,0,0))
            minetest.sound_play(("pmb_fenn_spear_hit"), {
                gain = 1.0,
                pos = self._last_pos,
                object = self.object,
                max_hear_distance = 20,
                pitch = (math.random()*0.1) + 0.90
            })
            self._prj_skip_objects = true
            return false
        end
    end,
    -- on_punch = function(self)
    --     self.object:remove()
    -- end,
    on_activate = function(self, staticdata, dtime_s)
        self.object:set_armor_groups({
            pierce=200,
            slash=100,
            blunt=100,
            magic=200,
            poison=100,
        })
        local data = minetest.deserialize(staticdata)
        if data then
            for key, val in pairs(data) do
                self[key] = val
            end
            if data._rotation then
                self.object:set_rotation(data._rotation)
            end
        end
    end,
    get_staticdata = function(self)
        local data = {}
        for i, key in pairs(self._pmb_staticdata_load_list) do
            if key and self[key] ~= nil then
                data[key] = self[key]
            end
        end
        data._age = self._age
        data.vel = self.object:get_velocity()
        return minetest.serialize(data)
    end,
    _pmb_staticdata_load_list = {
        "_age",
        "_pmb_stuck",
        "_rotation",
        "_prj_dir",
        "_pmb_pop_off_timer",
    },
    _age = 0,
    _prj_gravity = 19.8,
    _prj_damage_groups = table.copy(damage_groups),
})

