
pmb_mob_spawn.mob = {}
pmb_mob_spawn.mob_index = {}

function pmb_mob_spawn.register_mob(param)
    local name = param.name
    pmb_mob_spawn.mob[name] = param
    pmb_mob_spawn.mob_index[#pmb_mob_spawn.mob_index+1] = name

    for _, groupname in pairs(param.groups) do
        if not pmb_mob_spawn.cap[groupname] then
            pmb_mob_spawn.cap[groupname] = {max = 40, cur = 0}
        end
    end
end

--[[
pmb_mob_spawn.cap.pmb_kelar = {max=10, cur=0}
pmb_mob_spawn.register_mob({
    name = "pmb_kelar:kelar",
    groups = {"hostile", "pmb_kelar"},
    biomes = {},
    on_spawn = function(self, pos) end,
    can_spawn = function(pos, spawn_info)
        if pmb_mob_spawn.has_head_room(pos, 2)
        and pmb_mob_spawn.has_light(pos, 0, 7) then
            return true
        end
        return false
    end,
    can_despawn = function(self)
        local pos = self.object:get_pos()
        if not pos then
            return true
        end
        if pmb_mob_spawn.has_player_in_range(pos, 0, 40) then
            return false
        end
        return true
    end,
})
]]

function pmb_mob_spawn.default_register_mob(name)
    pmb_mob_spawn.register_mob({
        name = name,
        groups = {"passive"},
        biomes = {},
        on_spawn = function(self, pos) end,
        can_spawn = function(pos, spawn_info) return true end,
        can_despawn = function(pos) return true end,
    })
end

minetest.register_on_mods_loaded(function()
    for name, def in pairs(minetest.registered_entities) do
        if def._mob_spawn and not pmb_mob_spawn.mob[name] then
            pmb_mob_spawn.default_register_mob(name)
        end
    end
end)
