local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("pmb_mirecaves:stone", {
    description = pmb_util.desc(S("Mirestone"), "grey"),
    groups = { nature = 1, item_mirestone = 1, full_solid = 1, mirecaves = 1, stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_mirecaves_stone.png"},
    sounds = pmb_sounds.default_stone(),
})
pmb_util.register_all_shapes("pmb_mirecaves:stone")


minetest.register_node("pmb_mirecaves:stone_moss", {
    description = pmb_util.desc(S("Stone_moss"), "grey"),
    groups = { nature = 1, item_stone_moss = 1, full_solid = 1, mirecaves = 1, stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "pmb_mirecaves_stone_moss_top.png",
        "pmb_mirecaves_stone.png",
        "pmb_mirecaves_stone.png^[colorize:#000000:50^pmb_mirecaves_stone_moss_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"pmb_mirecaves:stone"},
            },
        },
    },
    sounds = pmb_sounds.default_soil(),
    light_source = 3,
})

minetest.register_node("pmb_mirecaves:stone_moss_glow", {
    description = pmb_util.desc(S("Glowing Stone Moss"), "grey"),
    groups = { nature = 1, item_stone_moss = 1, full_solid = 1, mirecaves = 1, stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "pmb_mirecaves_stone_moss_top.png",
        "pmb_mirecaves_stone.png",
        "pmb_mirecaves_stone.png^[colorize:#000000:60^pmb_mirecaves_stone_moss_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"pmb_mirecaves:stone"},
            },
        },
    },
    sounds = pmb_sounds.default_soil(),
    light_source = 3,
})

if true then
    local g = "pmb_mirecaves:stone"
    local a = "pmb_mirecaves:stone"
    minetest.register_craft({
        output = "pmb_mirecaves:stone_moss",
        recipe = {
            {g},
            {a},
        },
    })
end