pmb_elemental.magma = {}
function pmb_elemental.magma.do_sound(self, name, gain)
    minetest.sound_play(("pmb_elementals_"..name), {
        gain = gain or 1,
        pos = self.object:get_pos(),
        object = self.object,
    })
end

local animspeedmult = 0.7


if true then
    local stone = minetest.registered_entities["pmb_elementals:stone"]
    local mag = table.copy(stone)

    mag.initial_properties = table.copy(mag.initial_properties)
    mag.initial_properties.textures = {"pmb_elemental_magma.png"}
    mag._name = "pmb_elementals:magma"
    mag._drop = {
        max_items = 8,
        items = {
            {
                rarity = 5,
                items = {"pmb_elementals:elemental_core_magma"},
            },
            {
                rarity = 5,
                items = {"pmb_underworld:lava_coral"},
            },
            {
                rarity = 2,
                items = {"pmb_underworld:lava_brick_ornate 3"},
            },
            {
                rarity = 2,
                items = {"pmb_underworld:lava_brick 3"},
            },
            {
                rarity = 2,
                items = {"pmb_underworld:lava_rock 5"},
            },
            {
                rarity = 5,
                items = {"pmb_underworld:cortite"},
            },
            {
                rarity = 50,
                items = {"pmb_underworld:mythril"},
            },
        }
    }

    mag._pmb_speed = mag._pmb_speed / animspeedmult
    mag._pmb_acceleration = 10
    mag._knockback = 0.1
    mag._damagemult = 2
    mag._knockbackmult = 2

    for i, anim in pairs(mag._animations) do
        mag._animations[i] = table.copy(anim)
        mag._animations[i].speed = (mag._animations[i].speed or 24) / animspeedmult
    end

    minetest.register_entity("pmb_elementals:magma", mag)
end


minetest.register_craftitem("pmb_elementals:magma_spawn",
{
    description = "magma Elemental spawn egg",
    inventory_image = "pmb_elemental_stone.png",
    on_place = function(itemstack, placer, pointed_thing)
        local ent = minetest.add_entity(vector.offset(minetest.get_pointed_thing_position(pointed_thing), 0, 1, 0), "pmb_elementals:magma")
    end,
})
