
pmb_statusfx.register_status("featherfalling", {
    ----
    fx_allow_player = true,
    fx_allow_object = true,
    -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
    fx_only_tick_once = false,
    fx_only_apply_once = true,
    fx_timeout_individual = false,
    fx_use_player_functions_for_objects = true,
    ----
    on_apply_player = function(object, count, meta, params)
        meta.next_time = math.floor(meta.time-1)
        return false -- true to prevent apply
    end,
    on_remove_player = function(object, count, meta, not_timeout)
        return false -- true to prevent remove
    end,
    on_step_player = function(object, count, meta, dtime)
        local vel = object:get_velocity()
        vel.x = 0 vel.z = 0
        if vel.y > 0.0 then
            vel.y = dtime * 10
        elseif vel.y < -0.01 then
            vel.y = -vel.y * 0.07
        end
        object:add_velocity(vel)
        return false -- true to remove
    end,
    ----
    hud = pmb_statusfx.hud.make_effect("pmb_status_featherfalling.png")
    ----
})
