
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'oak_forest_dense'

pmb_biomes.register_biome({
    name = this_biome,

    node_top = 'pmb_soil:forest_dirt',
    depth_top = 1,

    node_filler = 'pmb_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'pmb_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 80,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 75,
    humidity_point = 71,
}, {"forest", "oak", "overworld", "mushrooms"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_sch.get_schematic_path

-- FOREST GRASS
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_soil:forest_grass",
    wherein		= {"pmb_soil:forest_dirt"},
    clust_scarcity	= 150,
    clust_num_ores	= 5,
    clust_size	= 6,
    y_max = alt_max,
    y_min = sealevel,
    noise_params = {
    offset  = 0.3,
    scale   = 0.1,
    spread  = {x=50, y=50, z=50},
    seed    = 12345,
    octaves = 3,
    persist = 0.6,
    lacunarity = 2,
    flags = "defaults",
    },
    biomes = {this_biome},
})


if true then
-- lots of bunched up trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
    offset = 0,
    scale = 0.02,
    spread = {x = 15, y = 150, z = 15},
    seed = 96,
    octaves = 2,
    persist = 0.1
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- bushes in large sparse clumps
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
    offset = -0.001,
    scale = 0.01,
    spread = {x = 25, y = 250, z = 25},
    seed = 3,
    octaves = 2,
    persist = 0.6
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- GIANT oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.007,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- GIANT oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0
})
-- really huge tree
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.004,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -5
})
-- GIANT oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.007,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- smaller trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0
})
-- smaller trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_small_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0
})
-- smaller trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_small_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0
})
-- smaller trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0
})

-- lots of bunched up trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
    offset = 0,
    scale = 0.015,
    spread = {x = 500, y = 200, z = 500},
    seed = 354,
    octaves = 2,
    persistence = 0.7,
    lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

end
