local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("pmb_underworld:arlior", {
    description = pmb_util.desc(S("Arlior"), "grey"),
    groups = { full_solid = 1, nature = 1, item_arlior = 1, underworld = 1, arlior = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_arlior.png"},
    sounds = pmb_sounds.default_stone(),
})
pmb_util.register_all_shapes("pmb_underworld:arlior")


minetest.register_node("pmb_underworld:arlioran", {
    description = pmb_util.desc(S("Arlioran"), "grey"),
    groups = { full_solid = 1, nature = 1, item_arlioran = 1, underworld = 1, arlior = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {
        "pmb_underworld_arlioran_top.png",
        "pmb_underworld_arlior.png",
        "pmb_underworld_arlioran_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"pmb_underworld:arlior"},
            },
        },
    },
    sounds = pmb_sounds.default_soil(),
})

if true then
    local g = "pmb_underworld:arlior_fola"
    local a = "pmb_underworld:arlior"
    minetest.register_craft({
        output = "pmb_underworld:arlioran",
        recipe = {
            {g},
            {a},
        },
    })
end
pmb_util.register_slab("pmb_underworld:arlioran", {drop="pmb_underworld:arlior_slab", offset_textures=true})
pmb_util.register_stair("pmb_underworld:arlioran", {drop="pmb_underworld:arlior_stair", offset_textures=true})

minetest.register_abm({
    nodenames = {"pmb_underworld:arlioran"},
    interval = 10,
    chance = 50,
    action = function(pos, node, active_object_count, active_object_count_wider)
        pmb_util.did_abm("grass spread")
        local abovenode = minetest.get_node(vector.offset(pos, 0, 1, 0))
        if (abovenode.name ~= "air") and minetest.get_item_group(abovenode.name, 'full_solid') > 0 then
            node.name = "pmb_underworld:arlior"
            minetest.set_node(pos, node)
        end
    end
})

