local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("pmb_underworld:mythrite", {
    description = pmb_util.desc(S("Mythrite"), "blue"),
    groups = { full_solid = 1, item_mythrite = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
})
if true then
    local s = "pmb_underworld:lava_rock"
    local m = "pmb_underworld:mythril_strand"
    minetest.register_craft({
        output = "pmb_underworld:mythrite 8",
        recipe = {
        {s, s, s},
        {s, m, s},
        {s, s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite")


minetest.register_node('pmb_underworld:mythrite_brick', {
    description = pmb_util.desc(S("Mythrite Bricks"), "blue"),
    groups = { full_solid = 1, item_mythrite_brick = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_brick.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
})
if true then
    local s = "pmb_underworld:mythrite"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_brick 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite_brick")


minetest.register_node('pmb_underworld:mythrite_lamp', {
    description = pmb_util.desc(S("Mythrite Lamp"), "blue"),
    groups = { full_solid = 1, item_mythrite_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_lamp.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = 14,
})
if true then
    local s = "pmb_underworld:mythrite_brick"
    local g = "pmb_underworld:glow_rock"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_lamp 6",
        recipe = {
        {s, s, s},
        {s, g, s},
        {s, s, s},
        },
    })
end
minetest.register_node('pmb_underworld:mythrite_brick_fine', {
    description = pmb_util.desc(S("Fine Mythrite Bricks"), "blue"),
    groups = { full_solid = 1, item_mythrite_brick_fine = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_brick_fine.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
})
if true then
    local s = "pmb_underworld:mythrite"
    local g = "pmb_underworld:mythrite_brick"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_brick_fine 4",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite_brick_fine")


minetest.register_node('pmb_underworld:mythrite_brick_pillar', {
    description = pmb_util.desc(S("Mythrite Brick Pillar"), "grey"),
    groups = { full_solid = 1, item_mythrite_brick_pillar = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_brick_pillar_top.png", "pmb_underworld_mythrite_brick_pillar_top.png", "pmb_underworld_mythrite_brick_pillar.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
    paramtype2 = "facedir",
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        pmb_util.rotate_and_place_against(pos, placer, itemstack, pointed_thing, {offset = 0})
    end,
})
if true then
    local g = "pmb_underworld:mythrite_brick"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_brick_pillar 3",
        recipe = {
        {g},
        {g},
        {g},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite_brick_pillar")


-- minetest.register_node('pmb_underworld:mythrite_brick_ornate', {
    -- description = pmb_util.desc(S("Ornate Mythrite Bricks"), "blue"),
--     groups = { full_solid = 1, item_mythrite_brick_ornate = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
--     tiles = {"pmb_underworld_mythrite_brick_ornate.png"},
--     sounds = pmb_sounds.default_stone(),
--     light_source = pmb_underworld.lava_rock_light + 2,
-- })
-- if true then
--     local s = "pmb_underworld:mythrite_brick"
--     minetest.register_craft({
--         output = "pmb_underworld:mythrite_brick_ornate 4",
--         recipe = {
--         {s, s},
--         {s, s},
--         },
--     })
-- end
-- pmb_util.register_all_shapes("pmb_underworld:mythrite_brick_ornate")

