

local dist = 50
local avg_factor = 15
function player_info.do_radar(player)
    local pi = player_info.get(player)
    if pi and not pi.radar_avg then pi.radar_avg = 10 end

    local dir = vector.new(
        (math.random()-0.5) * 2,
        (math.random()),
        (math.random()-0.5) * 2
    )
    local from_pos = pi and pi.eyepos or error("no eyepos")
    local to_pos = vector.add(from_pos, vector.multiply(dir, dist))

    local ray = minetest.raycast(from_pos, to_pos, false, false)

    local dist_to_node = -1

    for pointed_thing in ray do
        if pointed_thing.type == "node" and pointed_thing.under then
            local node = minetest.get_node(pointed_thing.under)
            if minetest.registered_nodes[node.name].walkable then
                dist_to_node = vector.distance(pointed_thing.under, from_pos)
                if dist_to_node > 0.1 then
                    break
                end
            end
        end
    end

    if dist_to_node == -1 then
        dist_to_node = dist
    end

    if pi then
        pi.radar_avg = (pi.radar_avg * (avg_factor-1) + dist_to_node) / avg_factor
    end

    -- minetest.log(dump(pi and pi.radar_avg))
    -- minetest.log(dump(dist_to_node))
end


