

function pmb_inventory.drop_contents(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    return pmb_inventory.drop_inventory_at_pos(inv, pos)
end


function pmb_inventory.drop_inventory_at_pos(inv, pos)
    local inv_lists = inv:get_lists()
    for list_name, list in pairs(inv_lists) do
        if not inv:is_empty(list_name) then
            for i=0, inv:get_size(list_name) do
                local stack = inv:get_stack(list_name, i)
                minetest.add_item(pos, stack)
            end
        end
        inv:set_list(list_name, {})
    end
    return true
end


minetest.register_on_dieplayer(function(player, reason)
    if (not pmb_vars) or not pmb_vars.drop_items_on_death then return end
    local inv = player:get_inventory()
    return pmb_inventory.drop_inventory_at_pos(inv, player:get_pos())
end)
