local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local function teleport_forward(itemstack, player, pointed_thing, mult)
    local dist = 20
    local pi = player:get_player_control()
    if pi and pi.aux1 then dist = 200 end
    if not mult then mult = 1 end
    dist = dist * mult
    local dir = player:get_look_dir()
    player:set_pos(vector.add(player:get_pos(), vector.multiply(dir, dist)))
end

minetest.register_tool("pmb_admin_tools:teleport_to", {
    description = minetest.get_modpath("pmb_util") and pmb_util.desc(S("Teleport Rod"), "purple") or "Teleport rod",
    _tt_long_desc = S("Teleports 20 nodes in some direction, or 200 if sprinting"),
    _tt_how_to_use = S(""),
    inventory_image = "pmb_admin_tools_teleport_to.png",
    wield_image = "pmb_admin_tools_teleport_to.png",
    tool_capabilities = {
        damage_groups = { fleshy = 999, cracky = 999 },
    },
    groups = { admin_tools = 1 },
    on_use = teleport_forward,
    on_secondary_use = function(itemstack, player, pointed_thing) teleport_forward(itemstack, player, pointed_thing, 3) end,
    on_place = function(itemstack, player, pointed_thing) teleport_forward(itemstack, player, pointed_thing, 3) end,
})

pmb_util.register_on_wield({
    name = "pmb_admin_tools:teleport_to",
    on_step = function(player, dtime, itemstack)
        if not minetest.get_modpath("playerphysics") then return end
        local pi = player:get_player_control()
        if pi and pi.aux1 and playerphysics then
            playerphysics.add_physics_factor(player, "speed", "pmb_admin_tools:teleport_to", 5)
        else
            playerphysics.remove_physics_factor(player, "speed", "pmb_admin_tools:teleport_to")
        end
    end,
    on_change_from_item = function(player)
        playerphysics.remove_physics_factor(player, "speed", "pmb_admin_tools:teleport_to")
    end,
})
