local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local pl = {}

local function check_player(player)
    if not pl[player] then
        pl[player] = {
            zoom = 0.9,
        }
    end
end

local function remove_player(player)
    if pl[player] then
        pmb_util.unset_fov(player, "pmb_admin_tools:camera")
    end
    pl[player] = nil
end

local function zoom_player(player, relative)
    check_player(player)

    pl[player].zoom = pl[player].zoom * relative
    pl[player].zoom = math.min(math.max(pl[player].zoom, 0.05), 1.5)
    pmb_util.set_fov(player, {
        tag = "pmb_admin_tools:camera",
        fov = pl[player].zoom,
        is_multiplier = true,
        transition_time = 0.1
    })
end

minetest.register_tool("pmb_admin_tools:camera", {
    description = S("For screenshots"),
    inventory_image = "pmb_admin_tools_camera.png",
    wield_image = "blank.png",
    groups = {},
    on_use = function(itemstack, user, pointed_thing)
        zoom_player(user, 0.7)
    end,
    on_secondary_use = function(itemstack, user, pointed_thing)
        zoom_player(user, 1.3)
    end,
    on_place = function(itemstack, user, pointed_thing)
        zoom_player(user, 1.3)
    end,
})

pmb_util.register_on_wield({
    name = "pmb_admin_tools:camera",
    on_change_to_item = function(player)
        zoom_player(player, 1)
    end,
    on_change_from_item = function(player)
        remove_player(player)
    end,
})
