local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local slab_box = {
    -8/16,  -8/16, -8/16,
     8/16,   0,     8/16
}

minetest.register_node("pmb_transit:obsidian_dais", {
    description = pmb_util.desc(S("Obsidian Dais"), "grey"),
    groups = { full_solid = 1, item_obsidian_dais = 1, oddly_breakable_by_hand = 3, cracky = 3, solid = 1, suffocates = 2, },
    drawtype = "nodebox",
    paramtype = "light",
    node_box = {
        type = "fixed",
        fixed = slab_box
    },
    use_texture_alpha = "clip",
    tiles = {
        "pmb_transit_obsidian_dais.png",
        "pmb_obsidian.png",
        "pmb_transit_obsidian_dais_side.png",
    },
    sounds = pmb_sounds.default_stone(),
})

if true then
    local m = "pmb_underworld:mythril"
    local o = "pmb_stone:obsidian"
    minetest.register_craft({
        output = "pmb_transit:obsidian_dais 4",
        recipe = {
            {"", m,"" },
            { o, o, o },
        },
    })
end
