local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


pmb_items.bucket = {}

function pmb_items.bucket.put_liquid(itemstack, user, pointed_thing, liquid_node_name)
    if not itemstack then return nil end

    -- check to make sure it can be placed here
    local pos
    if minetest.registered_nodes[minetest.get_node(pointed_thing.under).name].buildable_to then
        pos = pointed_thing.under
    elseif minetest.registered_nodes[minetest.get_node(pointed_thing.above).name].buildable_to then
        pos = pointed_thing.above
    else
        return itemstack
    end

    -- deal with items
    local name = user:get_player_name()
    local sdef = minetest.registered_items[itemstack:get_name()]
    if not minetest.is_creative_enabled(name) then
        local leftover = ItemStack(sdef._empty)
        itemstack:take_item(1)
        if itemstack:get_count() == 0 then
            itemstack = leftover
            leftover = nil
        end
        if leftover then
            leftover = leftover
            leftover = user:get_inventory():add_item("main", leftover)
        end
        if leftover then
            minetest.add_item(user:get_pos(), leftover)
        end
    end

    minetest.place_node(pos, {name=liquid_node_name})

    return itemstack
end

local function get_eyepos(player)
    local eyepos = vector.add(player:get_pos(), vector.multiply(player:get_eye_offset(), 0.1))
    eyepos.y = eyepos.y + player:get_properties().eye_height
    return eyepos
end

local function get_pointed_liquid(player, eyepos)
    if not eyepos then eyepos = get_eyepos(player) end
    local range = pmb_util.get_tool_range(player:get_wielded_item())
    local ray = minetest.raycast(eyepos, vector.add(eyepos, vector.multiply(player:get_look_dir(), range)), false, true)
    for pointed_thing in ray do
        if pointed_thing.type == "node" then
            local nd = minetest.registered_nodes[minetest.get_node(pointed_thing.under).name]
            if nd and nd.drawtype == "liquid" then
                return pointed_thing
            end
        end
    end
    return nil
end

function pmb_items.bucket.get_liquid(itemstack, user, pointed_thing, no_dig)
    if (not minetest.is_player(user)) then return end

    pointed_thing = get_pointed_liquid(user)

    if not pointed_thing then return nil end
    local node = minetest.get_node(pointed_thing.under)
    local sdef = minetest.registered_items[itemstack:get_name()]
    if not sdef._filled then return itemstack end
    local filled = sdef._filled[node.name]
    if not filled then return itemstack end

    if not no_dig then
        minetest.set_node(pointed_thing.under, {name="air"})
    end

    local name = user:get_player_name()
    if not minetest.is_creative_enabled(name) then
        local leftover = ItemStack(filled)
        itemstack:take_item(1)
        if itemstack:get_count() == 0 then
            itemstack = leftover
            leftover = nil
        end
        if leftover then
            leftover = leftover
            leftover = user:get_inventory():add_item("main", leftover)
        end
        if leftover then
            minetest.add_item(user:get_pos(), leftover)
        end
    end

    return itemstack
end

minetest.register_craftitem("pmb_items:wooden_bucket", {
    description = S("Wooden Bucket"),
    inventory_image = "pmb_wooden_bucket.png",
    groups = { item_wooden_bucket = 1, craftitem = 1, wooden_bucket = 1, },
    -- liquids_pointable = true,
    _filled = {
        ["pmb_liquids:water_source"] = "pmb_items:wooden_bucket_water",
        ["pmb_liquids:river_water_source"] = "pmb_items:wooden_bucket_river_water",
    },
    stack_max = 8,
    on_secondary_use = function(itemstack, user, pointed_thing)
        return pmb_items.bucket.get_liquid(itemstack, user, pointed_thing)
    end,
    on_place = function(itemstack, user, pointed_thing)
        return pmb_items.bucket.get_liquid(itemstack, user, pointed_thing)
    end,
})
minetest.register_craftitem("pmb_items:wooden_bucket_water", {
    description = S("Wooden Bucket of Water"),
    inventory_image = "pmb_wooden_bucket_water.png",
    groups = { item_wooden_bucket_water = 1, craftitem = 1, wooden_bucket = 1, water_bucket = 1},
    stack_max = 1,
    _empty = "pmb_items:wooden_bucket",
    on_place = function(itemstack, user, pointed_thing)
        return pmb_items.bucket.put_liquid(itemstack, user, pointed_thing, "pmb_liquids:water_source")
    end,
})
minetest.register_craftitem("pmb_items:wooden_bucket_river_water", {
    description = S("Wooden Bucket of River Water"),
    inventory_image = "pmb_wooden_bucket_water.png",
    groups = { item_wooden_bucket_water = 1, craftitem = 1, wooden_bucket = 1, water_bucket = 1},
    stack_max = 1,
    _empty = "pmb_items:wooden_bucket",
    on_place = function(itemstack, user, pointed_thing)
        return pmb_items.bucket.put_liquid(itemstack, user, pointed_thing, "pmb_liquids:river_water_source")
    end,
})

-- minetest.register_craft({
--     output = "pmb_items:wooden_bucket",
--     recipe = {
--         {"",             "group:stick",  ""},
--         {"group:planks", "",             "group:planks"},
--         {"group:planks", "group:planks", "group:planks"},
--     },
-- })
pmb_tcraft.register_group_craft({
    output = "pmb_items:wooden_bucket",
    items = {},
    group = "planks",
    group_count = 5
})


minetest.register_craftitem("pmb_items:wooden_cup", {
    description = S("Wooden cup"),
    inventory_image = "pmb_wooden_cup.png",
    groups = { item_wooden_cup = 1, craftitem = 1, wooden_cup = 1, },
    -- liquids_pointable = true,
    _filled = {
        ["pmb_liquids:water_source"] = "pmb_items:wooden_cup_water",
        ["pmb_liquids:river_water_source"] = "pmb_items:wooden_cup_water",
    },
    stack_max = 64,
    on_secondary_use = function(itemstack, user, pointed_thing)
        return pmb_items.bucket.get_liquid(itemstack, user, pointed_thing)
    end,
    on_place = function(itemstack, user, pointed_thing)
        return pmb_items.bucket.get_liquid(itemstack, user, pointed_thing, true)
    end,
})

minetest.register_craftitem("pmb_items:wooden_cup_water", {
    description = S("Cup of water"),
    inventory_image = "pmb_wooden_cup_water.png",
    groups = { item_wooden_cup = 1, craftitem = 1, wooden_cup = 1, food = 1, provides_water = 1 },
    stack_max = 64,
})
pmb_util.register_wield_use_delay("pmb_items:wooden_cup_water", {
    windup = 2,
    sound = {
        name = "pmb_food_gulp",
        gain = 0.1,
        max_hear_distance = 20,
        pitch = 1
    },
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["regeneration_8"] = 8*2+1,
    }, "pmb_items:wooden_cup", pmb_food.sound.gulp())
})
-- minetest.register_craft({
--     output = "pmb_items:wooden_cup 8",
--     recipe = {
--         {"group:planks", "",             "group:planks"},
--         {"group:planks", "",             "group:planks"},
--         {"group:planks", "group:planks", "group:planks"},
--     },
-- })
pmb_tcraft.register_group_craft({
    output = "pmb_items:wooden_cup",
    items = {},
    group = "planks",
    group_count = 1
})
