local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local pl = {}

minetest.register_node("pmb_crafters:crafting_bench", {
    description = pmb_util.desc(S("Crafting Bench"), "grey"),
    _tt_long_desc = S("Can craft more things."),
    drawtype = "mesh",
    mesh = "pmb_crafting_bench.b3d",
    groups = {
        oddly_breakable_by_hand = 2, crafter = 1,
        solid = 1, choppy = 1 },
    tiles = { "pmb_crafters_crafting_bench.png" },
    sounds = pmb_sounds.default_wood(),
    paramtype2 = "facedir",
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        if not minetest.is_player(clicker) then return itemstack end
        local fs = pmb_inventory.player.get_craft_menu(clicker, "crafting_bench")
        pl[clicker] = {time=1, last_formspec = fs}
        minetest.show_formspec(clicker:get_player_name(), "pmb_crafting_bench:crafting_bench", fs)
        return itemstack
    end,
})

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "pmb_crafting_bench:crafting_bench" then return end
    pmb_inventory.on_fields_tcraft(player, formname, fields)

    if fields.quit then
        pl[player] = nil
    end
end)

minetest.register_globalstep(function(dtime)
    for player, def in pairs(pl) do
        def.time = def.time - dtime
        if def.time <= 0 then
            def.time = 1
            local fs = pmb_inventory.player.get_craft_menu(player, "crafting_bench")
            if def.last_formspec ~= fs then
                def.last_formspec = fs
                minetest.show_formspec(player:get_player_name(), "pmb_crafting_bench:crafting_bench", fs)
            end
        end
    end
end)

pmb_tcraft.register_craft({
    output = "pmb_items:wooden_bowl",
    items = {
        ["pmb_items:wooden_bowl"] = 1,
    },
    method = {"crafting_bench"},
})
